/*
 * Decompiled with CFR 0.152.
 */
package javax.scj.util;

import devices.Console;
import javax.scj.util.SCJErrorReporter;
import vm.Memory;

public class DefaultSCJErrorReporter
implements SCJErrorReporter {
    @Override
    public void processExecutionError(Throwable t) {
        Console.println("SCJ Process execution error: " + t);
        if (t instanceof OutOfMemoryError) {
            Memory.reportMemoryUsage();
        }
    }

    @Override
    public void processOutOfMemoryError(OutOfMemoryError o) {
        Console.println("No more ImmortalMemory to print error");
        Console.println("Please increase ImmortalMemory to see full report");
    }

    @Override
    public void schedulerError(Throwable t) {
        Console.println("Scheduler error: " + t);
    }

    @Override
    public String processOutOfBackingStoreError(int start, int end, int left) {
        return "Out of backingstore: " + start + ", " + end + ", " + left;
    }
}

