/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import icecaptools.IcecapCompileMe;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import javax.scj.util.Const;

@SCJAllowed(value=Level.INFRASTRUCTURE)
class SleepingQueue {
    int heapSize = 0;
    protected int[] tree;

    public SleepingQueue(int size) {
        this.tree = new int[size + 1];
        this.makeEmptyTree(this.tree);
    }

    private void makeEmptyTree(int[] tree) {
        int i = 0;
        while (i < tree.length) {
            tree[i] = -999;
            ++i;
        }
    }

    int parent(int i) {
        return i / 2;
    }

    int left(int i) {
        return 2 * i;
    }

    int right(int i) {
        return 2 * i + 1;
    }

    void exchange(int a, int b) {
        int temp = this.tree[a];
        this.tree[a] = this.tree[b];
        this.tree[b] = temp;
    }

    void heapify(int i) {
        int l = this.left(i);
        int r = this.right(i);
        int smallest = l <= this.heapSize && this.getScjProcess((int)this.tree[l]).next.compareTo(this.getScjProcess((int)this.tree[r]).next) < 0 ? l : i;
        if (r <= this.heapSize && this.getScjProcess((int)this.tree[r]).next.compareTo(this.getScjProcess((int)this.tree[smallest]).next) < 0) {
            smallest = r;
        }
        if (smallest != i) {
            this.exchange(i, smallest);
            this.heapify(smallest);
        }
    }

    public void insert(ScjProcess obj) {
        if (this.heapSize + 1 == this.tree.length) {
            throw new IndexOutOfBoundsException();
        }
        ++this.heapSize;
        int i = this.heapSize;
        while (i > 1 && this.getScjProcess((int)this.tree[this.parent((int)i)]).next.compareTo(obj.next) > 0) {
            this.tree[i] = this.tree[this.parent(i)];
            i = this.parent(i);
        }
        this.tree[i] = obj.index;
    }

    @IcecapCompileMe
    public ScjProcess minimum() {
        if (this.heapSize > 0) {
            return this.getScjProcess(this.tree[1]);
        }
        return null;
    }

    @IcecapCompileMe
    public ScjProcess extractMin() {
        if (this.heapSize < 1) {
            return null;
        }
        ScjProcess min = this.getScjProcess(this.tree[1]);
        this.tree[1] = this.tree[this.heapSize];
        --this.heapSize;
        this.heapify(1);
        return min;
    }

    @IcecapCompileMe
    private ScjProcess getScjProcess(int processIdx) {
        if (processIdx == -999) {
            return null;
        }
        if (processIdx == -2) {
            return MissionSequencer.missSeqProcess;
        }
        if (processIdx == -1) {
            return ScjProcess.idleProcess;
        }
        return (ScjProcess)Mission.missionBehaviour.getProcess(processIdx);
    }

    public void remove(ScjProcess obj) {
        if (obj == null) {
            return;
        }
        int i = this.find(obj.index);
        if (i != -999) {
            this.tree[i] = this.tree[this.heapSize];
            --this.heapSize;
            this.heapify(i);
        }
    }

    private int find(int value) {
        int i = 1;
        while (i <= this.heapSize) {
            if (this.tree[i] == value) {
                return i;
            }
            ++i;
        }
        return -999;
    }

    public void print() {
        Console.println("sQueue size = " + this.heapSize);
        int i = 1;
        while (i <= this.heapSize) {
            Console.println(this.getScjProcess(this.tree[i]).toString());
            ++i;
        }
    }

    public static void main(String[] args) {
        System.out.println("Main to SleepingQueue begin");
        SleepingQueue queue = new SleepingQueue(Const.DEFAULT_SLEEPING_QUEUE_SIZE);
        int n = 5;
        int i = 0;
        while (i < n) {
            ++i;
        }
        queue.print();
        i = 0;
        while (i < 2 * n) {
            System.out.println("====== remove ======");
            ScjProcess process = queue.extractMin();
            System.out.println("Removed: " + process);
            ++i;
        }
    }
}

