/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import icecaptools.IcecapCompileMe;
import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.RelativeTime;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.ManagedSchedMethods;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.PriorityFrame;
import javax.safetycritical.PrioritySchedulerImpl;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import javax.scj.util.Const;
import vm.ClockInterruptHandler;
import vm.Process;

@SCJAllowed(value=Level.LEVEL_1)
public class PriorityScheduler
extends javax.realtime.PriorityScheduler {
    PriorityFrame pFrame;
    ScjProcess current;
    PrioritySchedulerImpl prioritySchedulerImpl;
    Clock rtClock;
    RelativeTime timeGrain;
    AbsoluteTime now;
    private static PriorityScheduler scheduler = new PriorityScheduler();
    ScjProcess outerMostSeqProcess = null;
    private Process mainProcess;

    @SCJAllowed(value=Level.LEVEL_1)
    public static PriorityScheduler instance() {
        return scheduler;
    }

    private PriorityScheduler() {
        int[] schedulerStack = new int[Const.PRIORITY_SCHEDULER_STACK_SIZE];
        this.pFrame = new PriorityFrame(Const.DEFAULT_PRIORITY_QUEUE_SIZE);
        this.prioritySchedulerImpl = new PrioritySchedulerImpl();
        ClockInterruptHandler.initialize(this.prioritySchedulerImpl, schedulerStack);
        this.rtClock = Clock.getRealtimeClock();
        this.now = new AbsoluteTime(this.rtClock);
        this.rtClock.getTime(this.now);
        this.timeGrain = new RelativeTime(0L, 0, this.rtClock);
        this.rtClock.getResolution(this.timeGrain);
        scheduler = this;
    }

    void addOuterMostSeq(MissionSequencer<?> seq) {
        ScjProcess process = ManagedSchedMethods.createScjProcess(seq);
        process.index = -2;
        MissionSequencer.missSeqProcess = process;
        this.outerMostSeqProcess = (ScjProcess)seq.process;
        this.pFrame.addProcess(process);
    }

    private void processStart() {
        ClockInterruptHandler clockHandler = ClockInterruptHandler.instance;
        this.mainProcess = new Process(null, null);
        clockHandler.register();
        clockHandler.enable();
        clockHandler.startClockHandler(this.mainProcess);
        clockHandler.yield();
    }

    @IcecapCompileMe
    void stop(Process current) {
        current.transferTo(this.mainProcess);
    }

    void start() {
        this.current = this.pFrame.readyQueue.extractMax();
        this.processStart();
    }

    void release(AperiodicEventHandler handler) {
        ScjProcess process = (ScjProcess)handler.process;
        ClockInterruptHandler.instance.disable();
        if (process.state != 2 && process.state == 3) {
            process.state = 1;
            process.start();
            this.pFrame.readyQueue.insert(process);
        }
        ClockInterruptHandler.instance.enable();
    }

    @IcecapCompileMe
    ScjProcess move() {
        if (this.current == ScjProcess.idleProcess) {
            this.pFrame.readyQueue.insert(this.current);
        } else {
            this.current.gotoNextState(this.pFrame);
        }
        ScjProcess process = this.pFrame.sleepingQueue.minimum();
        this.rtClock.getTime(this.now);
        while (process != null && process.next.compareTo(this.now) <= 0) {
            process.state = 1;
            ScjProcess t = this.pFrame.sleepingQueue.extractMin();
            this.pFrame.readyQueue.insert(t);
            process = this.pFrame.sleepingQueue.minimum();
        }
        ScjProcess nextProcess = this.pFrame.readyQueue.extractMax();
        nextProcess.state = 2;
        this.current = nextProcess;
        if (this.current == ScjProcess.idleProcess && this.pFrame.sleepingQueue.heapSize == 0 && this.pFrame.waitQueue.queueSize == 0 && this.pFrame.lockQueue.queueSize == 0) {
            this.current.getTarget().cleanUp();
            return null;
        }
        return nextProcess;
    }

    ScjProcess getCurrentProcess() {
        return this.current;
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public int getMaxHardwarePriority() {
        return 150;
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public int getMinHardwarePriority() {
        return 101;
    }

    void insertReadyQueue(ScjProcess process) {
        this.pFrame.readyQueue.insert(process);
    }

    void addProcessToLockQueue(Object target, ScjProcess process) {
        this.pFrame.lockQueue.addProcess(target, process);
    }

    ScjProcess getProcessFromLockQueue(Object monitor) {
        return this.pFrame.lockQueue.getNextProcess(monitor);
    }

    void wait(Object target) {
        this.prioritySchedulerImpl.wait(target);
    }

    void notify(Object target) {
        this.prioritySchedulerImpl.notify(target);
    }

    void notifyAll(Object target) {
        this.prioritySchedulerImpl.notifyAll(target);
    }

    void moveToNext() {
        ScjProcess nextProcess = this.pFrame.readyQueue.extractMax();
        nextProcess.state = 2;
        this.current = nextProcess;
    }

    public void printQueues() {
        ClockInterruptHandler.instance.disable();
        Console.println("");
        this.pFrame.readyQueue.print();
        this.pFrame.sleepingQueue.print();
        this.pFrame.lockQueue.print();
        this.pFrame.waitQueue.print();
        Console.println("");
        ClockInterruptHandler.instance.enable();
    }
}

