/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import icecaptools.IcecapCompileMe;
import javax.safetycritical.Mission;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed(value=Level.INFRASTRUCTURE)
class PriorityQueue {
    protected int heapSize = 0;
    protected int[] tree;

    public PriorityQueue(int size) {
        this.tree = new int[size + 1];
        this.makeEmptyTree(this.tree);
    }

    private void makeEmptyTree(int[] tree) {
        int i = 0;
        while (i < tree.length) {
            tree[i] = -999;
            ++i;
        }
    }

    int parent(int i) {
        return i / 2;
    }

    int left(int i) {
        return 2 * i;
    }

    int right(int i) {
        return 2 * i + 1;
    }

    void exchange(int a, int b) {
        int temp = this.tree[a];
        this.tree[a] = this.tree[b];
        this.tree[b] = temp;
    }

    void heapify(int i) {
        int l = this.left(i);
        int r = this.right(i);
        int largest = l <= this.heapSize && this.getScjProcess(this.tree[l]).compareTo(this.getScjProcess(this.tree[r])) > 0 ? l : i;
        if (r <= this.heapSize && this.getScjProcess(this.tree[r]).compareTo(this.getScjProcess(this.tree[largest])) > 0) {
            largest = r;
        }
        if (largest != i) {
            this.exchange(i, largest);
            this.heapify(largest);
        }
    }

    @IcecapCompileMe
    public void insert(ScjProcess obj) {
        if (this.heapSize + 1 == this.tree.length) {
            throw new IndexOutOfBoundsException();
        }
        ++this.heapSize;
        int i = this.heapSize;
        while (i > 1 && this.getScjProcess(this.tree[this.parent(i)]).compareTo(obj) < 0) {
            this.tree[i] = this.tree[this.parent(i)];
            i = this.parent(i);
        }
        this.tree[i] = obj.index;
    }

    @IcecapCompileMe
    public ScjProcess extractMax() {
        if (this.heapSize < 1) {
            return null;
        }
        ScjProcess max = this.getScjProcess(this.tree[1]);
        this.tree[1] = this.tree[this.heapSize];
        --this.heapSize;
        this.heapify(1);
        return max;
    }

    private ScjProcess getScjProcess(int processIdx) {
        if (processIdx == -999) {
            return null;
        }
        if (processIdx == -2) {
            return PriorityScheduler.instance().outerMostSeqProcess;
        }
        if (processIdx == -1) {
            return ScjProcess.idleProcess;
        }
        return (ScjProcess)Mission.missionBehaviour.getProcess(processIdx);
    }

    public void remove(ScjProcess obj) {
        if (obj == null) {
            return;
        }
        int i = this.find(obj.index);
        if (i != -999) {
            this.tree[i] = this.tree[this.heapSize];
            --this.heapSize;
            this.heapify(i);
        }
    }

    private int find(int value) {
        int i = 1;
        while (i <= this.heapSize) {
            if (this.tree[i] == value) {
                return i;
            }
            ++i;
        }
        return -999;
    }

    public void print() {
        Console.println("readyQueue size = " + this.heapSize);
    }

    public static void main(String[] args) {
        System.out.println("Main to PriorityQueue begin");
        PriorityQueue queue = new PriorityQueue(20);
        int n = 5;
        boolean priority = true;
        int i = 0;
        while (i < n) {
            ++i;
        }
        queue.print();
        i = 0;
        while (i < 2 * n) {
            System.out.println("====== remove ======");
            ScjProcess process = queue.extractMax();
            System.out.println("Removed: " + process);
            ++i;
        }
    }
}

