/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import icecaptools.IcecapCompileMe;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.ManagedEventHandler;
import javax.safetycritical.ManagedLongEventHandler;
import javax.safetycritical.ManagedSchedMethodsMulticore;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ManagedThread;
import javax.safetycritical.OneShotEventHandler;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.Process;
import vm.Memory;

@IcecapCompileMe
class OSProcess
extends Process {
    public OSProcess(ManagedSchedulable ms) {
        this.msObject = ms;
        this.setProcess(ms);
        this.executable = new MyThread(new Runnable(){

            @Override
            public void run() {
                try {
                    OSProcess.this.runLogic(OSProcess.this.msObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, this);
    }

    private void runLogic(ManagedSchedulable ms) {
        ManagedSchedMethodsMulticore.executeManagedSchedulable(ms);
    }

    private ThreadInfo setThreadInfo(ManagedSchedulable ms) {
        int priority = -99;
        int isPeriodic = -99;
        long start = -99L;
        long period = -99L;
        if (ms instanceof ManagedEventHandler) {
            priority = ((ManagedEventHandler)ms).getPriorityParam().getPriority();
            if (ms instanceof PeriodicEventHandler) {
                isPeriodic = 99;
                start = ((PeriodicEventHandler)ms).getStart();
                period = ((PeriodicEventHandler)ms).getPeriod();
            }
            if (ms instanceof OneShotEventHandler) {
                isPeriodic = 98;
                start = ((OneShotEventHandler)ms).getStart();
            }
            if (ms instanceof AperiodicEventHandler) {
                isPeriodic = 97;
            }
        } else {
            priority = ms instanceof ManagedThread ? ((ManagedThread)ms).getPriorityParam().getPriority() : ((ManagedLongEventHandler)ms).getPriorityParam().getPriority();
        }
        return new ThreadInfo(priority, isPeriodic, start, period);
    }

    static native void requestTermination_c(Thread var0);

    static native void testCancel_c();

    static native void setMemoryArea(Memory var0);

    static native Memory getCurrentMemoryArea();

    static native void setOuterMostMissionSequencer(int var0);

    static native void setTimerfd(int var0, long var1);

    static native void initSpecificID();

    public static native int getThreadID();

    public static native int getCurrentCPUID();

    public static native int getAvailableCPUCount();

    public static native int isProcessorInSet(int var0);

    public static native int getAllCPUCount();

    static native void setOMMSAffinitySet(int var0);

    static native void setAffinity(int var0, int[] var1);

    static native int getMaxPriority();

    class MyThread
    extends Thread {
        OSProcess process;
        ThreadInfo info;
        int startTimer_c;
        int id;
        int[] processors;
        int sizeOfProcessor;

        MyThread(Runnable run, OSProcess process) {
            super(run);
            this.startTimer_c = -99;
            this.id = -99;
            this.process = process;
            this.info = OSProcess.this.setThreadInfo(process.msObject);
            this.processors = process.msObject instanceof ManagedEventHandler ? ((ManagedEventHandler)process.msObject).set.processorSet : ((ManagedThread)process.msObject).set.processorSet;
            this.sizeOfProcessor = this.processors.length;
        }

        OSProcess getProcess() {
            return this.process;
        }
    }

    class ThreadInfo {
        private int priority;
        private int isPeriodic;
        private long start;
        private long period;

        public ThreadInfo(int priority, int isPeriodic, long start, long period) {
            this.priority = priority;
            this.isPeriodic = isPeriodic;
            this.start = start;
            this.period = period;
        }
    }
}

