/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import icecaptools.IcecapCompileMe;
import javax.realtime.Scheduler;
import javax.safetycritical.ManagedSchedMethods;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.ScjProcess;
import vm.ClockInterruptHandler;
import vm.Monitor;
import vm.Process;

final class CyclicScheduler
extends Scheduler
implements vm.Scheduler {
    MissionSequencer<?> seq;
    private ScjProcess current;
    private static CyclicScheduler scheduler;
    private Process mainProcess;

    static CyclicScheduler instance() {
        if (scheduler == null) {
            scheduler = new CyclicScheduler();
        }
        return scheduler;
    }

    private CyclicScheduler() {
        int[] sequencerStack = new int[2048];
        ClockInterruptHandler.initialize(this, sequencerStack);
    }

    @Override
    public Process getNextProcess() {
        ScjProcess scjProcess = CyclicScheduler.instance().getCurrentProcess();
        if (scjProcess.getTarget() instanceof MissionSequencer && ((MissionSequencer)scjProcess.getTarget()).currState == 6) {
            scjProcess.getTarget().cleanUp();
            CyclicScheduler.instance().stop(scjProcess.process);
        }
        return scjProcess.process;
    }

    private void processStart() {
        ClockInterruptHandler clockHandler = ClockInterruptHandler.instance;
        this.mainProcess = new Process(null, null);
        clockHandler.register();
        clockHandler.enable();
        clockHandler.startClockHandler(this.mainProcess);
        clockHandler.yield();
    }

    @IcecapCompileMe
    void stop(Process current) {
        current.transferTo(this.mainProcess);
    }

    void start(MissionSequencer<?> seq) {
        this.seq = seq;
        this.current = ManagedSchedMethods.createScjProcess(seq);
        this.processStart();
    }

    ScjProcess getCurrentProcess() {
        return this.current;
    }

    @Override
    public void wait(Object target) {
    }

    @Override
    public void notify(Object target) {
    }

    @Override
    public void notifyAll(Object target) {
    }

    @Override
    public Monitor getDefaultMonitor() {
        return null;
    }
}

