/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.RelativeTime;
import javax.safetycritical.CyclicSchedule;
import javax.safetycritical.Frame;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ManagedSchedulableSet;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.Phase;
import javax.safetycritical.annotate.SCJAllowed;
import vm.ClockInterruptHandler;
import vm.RealtimeClock;

@SCJAllowed
public abstract class CyclicExecutive
extends Mission {
    Clock rtClock = Clock.getRealtimeClock();
    AbsoluteTime next = this.rtClock.getTime();
    RelativeTime deltaTime = new RelativeTime(this.rtClock);

    @SCJAllowed
    public CyclicExecutive() {
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public abstract CyclicSchedule getSchedule(PeriodicEventHandler[] var1);

    @Override
    void runInitialize() {
        this.phaseOfMission = Phase.INITIALIZE;
        this.msSetForMission = new ManagedSchedulableSet();
        this.initialize();
    }

    @Override
    void runExecute() {
        ManagedSchedulable[] msObjects = Mission.getMission().msSetForMission.managedSchObjects;
        PeriodicEventHandler[] pevs = new PeriodicEventHandler[Mission.getMission().msSetForMission.noOfRegistered];
        int i = 0;
        while (i < pevs.length) {
            pevs[i] = (PeriodicEventHandler)msObjects[i];
            ++i;
        }
        CyclicSchedule schedule = this.getSchedule(pevs);
        Frame[] frames = schedule.getFrames();
        int step = 0;
        while (!this.missionTerminate) {
            PeriodicEventHandler[] handlers = frames[step].handlers;
            int n = handlers.length;
            int handlerIdx = 0;
            while (handlerIdx < n) {
                handlers[handlerIdx].privateMemory.enter(handlers[handlerIdx]);
                ++handlerIdx;
            }
            this.waitForNextFrame(frames[step].duration);
            step = (step + 1) % frames.length;
        }
    }

    @Override
    void runCleanup(MissionMemory missMem) {
        ClockInterruptHandler.instance.disable();
        Mission.getMission().msSetForMission.terminateMSObjects();
        this.cleanUp();
        missMem.resetArea();
        ClockInterruptHandler.instance.enable();
    }

    private void waitForNextFrame(RelativeTime duration) {
        this.next.add(duration, this.next);
        RealtimeClock.delayNativeUntil(this.next);
    }
}

