/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.RuntimeInvisibleAnnotations;
import org.apache.bcel.classfile.Visitor;

public class AnnotationsAttribute
extends Attribute {
    private static final long serialVersionUID = 1L;
    private HashMap<String, HashMap<String, String>> annotations = new HashMap();

    public AnnotationsAttribute(int nameIndex, int length, ConstantPool cp) {
        super((byte)-1, nameIndex, length, cp);
    }

    public void read(DataInputStream in, ConstantPool cp) throws IOException {
        int numAnnotations = in.readShort();
        int i = 0;
        while (i < numAnnotations) {
            short typeIndex = in.readShort();
            String type = cp.constantToString(cp.getConstant((int)typeIndex));
            HashMap<String, String> nvPairs = new HashMap<String, String>();
            this.annotations.put(type.replace("/", "."), nvPairs);
            int numElementValuePairs = in.readShort();
            int j = 0;
            while (j < numElementValuePairs) {
                short nameIndex = in.readShort();
                String name = cp.constantToString(cp.getConstant((int)nameIndex));
                byte tag = in.readByte();
                if (tag == 115) {
                    short constValueIndex = in.readShort();
                    String value = cp.constantToString(cp.getConstant((int)constValueIndex));
                    nvPairs.put(name, value);
                } else if (tag == 101) {
                    in.readShort();
                    in.readShort();
                } else {
                    throw new UnsupportedOperationException("Unknown attribute type attributes");
                }
                ++j;
            }
            ++i;
        }
    }

    public static AnnotationsAttribute getAttribute(RuntimeInvisibleAnnotations attribute) {
        AnnotationsAttribute aattr = new AnnotationsAttribute(attribute.getNameIndex(), attribute.getLength(), attribute.getConstantPool());
        int numAnnotations = attribute.getNumAnnotations();
        int i = 0;
        while (i < numAnnotations) {
            AnnotationEntry ae = attribute.getAnnotationEntries()[i];
            String type = ae.getAnnotationType();
            HashMap<String, String> nvPairs = new HashMap<String, String>();
            aattr.annotations.put(type.replace("/", "."), nvPairs);
            int numElementValuePairs = ae.getNumElementValuePairs();
            int j = 0;
            while (j < numElementValuePairs) {
                ElementValuePair nextPair = ae.getElementValuePairs()[j];
                String name = nextPair.getNameString();
                ElementValue evalue = nextPair.getValue();
                String value = evalue.stringifyValue();
                nvPairs.put(name, value);
                ++j;
            }
            ++i;
        }
        return aattr;
    }

    public void accept(Visitor v) {
        throw new UnsupportedOperationException();
    }

    public Attribute copy(ConstantPool _constant_pool) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.annotations.toString();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        String key = "L" + annotationClass.getName().replace("/", ".") + ";";
        final HashMap<String, String> nvPairs = this.annotations.get(key);
        if (nvPairs == null) {
            return null;
        }
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                return nvPairs.get(m.getName());
            }
        };
        return (A)((Annotation)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{annotationClass}, handler));
    }
}

