/*
 * Decompiled with CFR 0.152.
 */
package gc;

import devices.Console;
import gc.BitMap;
import gc.GCMonitor;
import gc.GarbargeCollectorController;
import icecaptools.IcecapCompileMe;
import reflect.ClassInfo;
import reflect.ObjectInfo;
import thread.Semaphore;
import thread.Thread;
import util.LiveSet;
import util.ReferenceIterator;
import vm.HVMHeap;
import vm.Heap;

public class GarbageCollector
implements Runnable {
    public boolean GCstopped;
    private static Semaphore gcFinished;
    private static GCMonitor monitor;
    private static Thread gc;
    private static ReferenceIterator staticRoots;
    private static LiveSet liveSet;
    private static BitMap bitMap;
    private static boolean GCIsRunning;
    private static Heap heap;
    private Semaphore startGC;
    private Semaphore endGC;

    static {
        GarbageCollector.init();
    }

    @IcecapCompileMe
    private static void init() {
        GCIsRunning = false;
        heap = HVMHeap.getHeap();
        bitMap = new BitMap(heap.getBlockSize(), heap.getStartAddress(), heap.getHeapSize());
        heap.setBitMap(bitMap);
        Object hack = new Object();
        GarbageCollector.newBarrier(ObjectInfo.getAddress(hack));
        GarbageCollector.writeBarrier(0, 0);
        short count = ClassInfo.getNumberOfClasses();
        do {
            count = (short)(count - 1);
            ClassInfo.getClassInfo(count);
        } while (count > 0);
    }

    public GarbageCollector(Semaphore startGC, Semaphore endGC) {
        this.startGC = startGC;
        this.endGC = endGC;
        this.GCstopped = false;
    }

    @IcecapCompileMe
    private static void writeBarrier(int source, int oldRef) {
        if (GCIsRunning && Thread.currentThread() != gc && !bitMap.isRefBlack(source) && oldRef != 0 && bitMap.isRefWhite(oldRef)) {
            liveSet.push(oldRef);
        }
    }

    @IcecapCompileMe
    private static void newBarrier(int ref) {
        if (GCIsRunning) {
            if (Thread.currentThread() == gc) {
                bitMap.shadeRefWhite(ref);
            } else {
                bitMap.shadeRefBlack(ref);
            }
        } else if (bitMap != null) {
            bitMap.shadeRefWhite(ref);
        }
    }

    private void setRoots() {
        liveSet.clear();
        staticRoots = heap.getStaticRef();
        while (staticRoots.hasNext()) {
            int nextRoot = staticRoots.next();
            if (nextRoot == 0) continue;
            monitor.addStaticRoot(nextRoot);
            liveSet.push(nextRoot);
        }
        ReferenceIterator stackRoots = heap.getRefFromStacks();
        while (stackRoots.hasNext()) {
            int possibleRef = stackRoots.next();
            if (possibleRef == 0 || !bitMap.isWithinRangeOfHeap(possibleRef) || !heap.isRefAnObj(possibleRef) || !heap.isRefAllocated(possibleRef)) continue;
            liveSet.push(possibleRef);
            monitor.addStackRoot(possibleRef);
        }
    }

    private void traverse(LiveSet nodes) {
        while (!nodes.isEmpty()) {
            int parent = nodes.pop();
            ReferenceIterator children = heap.getRefFromObj(parent);
            while (children.hasNext()) {
                int child = children.next();
                if (child == 0 || !bitMap.isWithinRangeOfHeap(child)) continue;
                monitor.visitChild(parent, child);
                if (bitMap.isRefBlack(child)) continue;
                nodes.push(child);
            }
            bitMap.shadeRefBlack(parent);
        }
    }

    private void makeFreeList() {
        ReferenceIterator freeList = bitMap.getFreeList();
        while (freeList.hasNext()) {
            monitor.freeObject(freeList.next());
        }
    }

    @Override
    public void run() {
        while (!this.GCstopped) {
            Thread.print("GC wait for next cycle");
            this.startGC.acquire();
            Thread.print("starting GC cycle");
            GCIsRunning = true;
            Thread.getScheduler().disable();
            this.setRoots();
            Thread.getScheduler().enable();
            this.traverse(liveSet);
            GCIsRunning = false;
            this.makeFreeList();
            this.endGC.release();
            gcFinished.release();
        }
    }

    public static void start() {
        Semaphore startGC = new Semaphore(0);
        Semaphore endGC = new Semaphore(0);
        gcFinished = new Semaphore(0);
        Thread controller = new Thread(new GarbargeCollectorController(startGC, endGC));
        gc = new Thread(new GarbageCollector(startGC, endGC));
        liveSet = new LiveSet(bitMap);
        Console.println("Bitmap size = " + bitMap.getSize());
        controller.start();
        gc.start();
    }

    public static void registerMonitor(GCMonitor m) {
        monitor = m;
    }

    public static void requestCollection() {
        GarbargeCollectorController.requestCollection();
    }

    public static void waitForNextCollection() {
        gcFinished.acquire();
    }
}

