/*
 * Decompiled with CFR 0.152.
 */
package devices.ev3;

import devices.ev3.MotorPort;

public class Motor {
    public static final byte opOUTPUT_POWER = -92;
    public static final byte opOUTPUT_START = -90;
    public static final byte opOUTPUT_STOP = -93;
    private MotorPort port;
    private byte power;

    private static native void setMotor(byte var0, byte var1, byte var2);

    public Motor(MotorPort port) {
        this.port = port;
    }

    public void setPower(byte power) {
        if (power > 100) {
            power = (byte)100;
        }
        if (power < 0) {
            power = 0;
        }
        this.power = power;
        Motor.setMotor((byte)-92, this.port.getPort(), power);
    }

    public void start() {
        Motor.setMotor((byte)-90, this.port.getPort(), (byte)0);
    }

    public void stop() {
        Motor.setMotor((byte)-93, this.port.getPort(), (byte)0);
    }

    public void setDirection(Direction direction) {
        int adjustment = 1;
        switch (direction) {
            case FORWARD: {
                if (this.power >= 0) break;
                adjustment = -1;
                break;
            }
            case BACKWARD: {
                if (this.power <= 0) break;
                adjustment = -1;
            }
        }
        if (adjustment == -1) {
            this.power = (byte)(adjustment * this.power);
            Motor.setMotor((byte)-92, this.port.getPort(), this.power);
        }
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

