/*
 * Decompiled with CFR 0.152.
 */
package devices;

import devices.Console;
import icecaptools.IcecapCompileMe;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.realtime.AbsoluteTime;
import vm.Address;
import vm.Address32Bit;
import vm.HardwareObject;
import vm.RealtimeClock;

public class System {
    static AbsoluteTime now;

    public static void delay(int i) {
        while (i > 0) {
            --i;
        }
    }

    public static native void blink();

    public static native void snapshot();

    public static native void lockROM();

    public static native void resetMemory();

    public static void initializeSystemClass() {
        java.lang.System.setOut(new DevicePrintStream());
    }

    public static void includeHWObjectSupport() {
        DummyHWObject dummy = new DummyHWObject(new Address32Bit(0));
        dummy.dummyField = 42;
    }

    @IcecapCompileMe
    public static long currentTimeMillis() {
        RealtimeClock clock = RealtimeClock.getRealtimeClock();
        if (now == null) {
            now = new AbsoluteTime();
        }
        clock.getCurrentTime(now);
        return now.getMilliseconds();
    }

    @IcecapCompileMe
    public static String getProperty(String key) {
        if (key.equals("line.separator")) {
            return "\n";
        }
        if (key.equals("org.jmlspecs.openjml.racexceptions")) {
            return "true";
        }
        if (key.equals("org.jmlspecs.openjml.racjavaassert")) {
            return "true";
        }
        return null;
    }

    private static class DevicePrintStream
    extends PrintStream {
        @Override
        public void println(String msg) {
            Console.println(msg);
        }

        @Override
        public void print(String msg) {
            Console.print(msg);
        }

        @Override
        public void print(int i) {
            Console.print(i);
        }

        @Override
        public void println() {
            Console.println("");
        }

        @Override
        public void print(boolean b) {
            Console.println("print boolean b unimplemented");
        }

        @Override
        public void print(char c) {
            Console.print(String.valueOf(c));
        }

        @Override
        public void print(long l) {
            Console.println("print long l unimplemented");
        }

        @Override
        public void print(float f) {
            Console.println("print float f unimplemented");
        }

        @Override
        public void print(double d) {
            Console.println("print double d unimplemented");
        }

        @Override
        public void print(char[] s) {
            Console.println("print char[] s unimplemented");
        }

        @Override
        public void print(Object obj) {
            Console.println("print Object obj unimplemented");
        }

        public DevicePrintStream() {
            super(new DummyOutputStream(), true);
        }

        private static class DummyOutputStream
        extends OutputStream {
            private DummyOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                throw new IOException();
            }
        }
    }

    private static class DummyHWObject
    extends HardwareObject {
        public int dummyField;

        public DummyHWObject(Address address) {
            super(address);
        }
    }
}

