/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.NewList;
import org.junit.Assert;
import org.junit.Test;

public class TestNewList {
    @Test
    public void testNewList() throws Exception {
        NewList newList1 = new NewList("java.lang.String;java.lang.Object");
        String actual = newList1.toString();
        Assert.assertEquals((Object)actual, (Object)"java.lang.Object;java.lang.String");
        newList1.addElement("java.lang.String");
        actual = newList1.toString();
        Assert.assertEquals((Object)actual, (Object)"java.lang.Object;java.lang.String");
        NewList newList2 = new NewList("java.lang.String;java.lang.Object");
        Assert.assertTrue((boolean)newList1.equals(newList2));
        newList2.addElement("java.lang.Raw");
        Assert.assertFalse((boolean)newList1.equals(newList2));
        Assert.assertFalse((boolean)newList1.equals(null));
        newList1.addElement("java.lang.Fail");
        newList1.merge(newList2);
        Assert.assertEquals((Object)"java.lang.Fail;java.lang.Object;java.lang.Raw;java.lang.String", (Object)newList1.toString());
        Assert.assertEquals((Object)"java.lang.Object;java.lang.Raw;java.lang.String", (Object)newList2.toString());
        Assert.assertTrue((boolean)newList2.lessThanOrEquals(newList1));
        Assert.assertTrue((boolean)new NewList().lessThanOrEquals(newList2));
        Assert.assertTrue((boolean)new NewList().lessThanOrEquals(newList1));
        Assert.assertFalse((boolean)newList2.lessThanOrEquals(new NewList()));
        Assert.assertFalse((boolean)newList1.lessThanOrEquals(new NewList()));
        Assert.assertFalse((boolean)newList1.lessThanOrEquals(null));
        newList2.addElement("");
        Assert.assertEquals((Object)"java.lang.Object;java.lang.Raw;java.lang.String", (Object)newList2.toString());
        NewList copy = new NewList(newList2);
        Assert.assertEquals((Object)"java.lang.Object;java.lang.Raw;java.lang.String", (Object)copy.toString());
    }

    public void testMerge() {
        NewList list1 = new NewList("a;c;e");
        NewList list2 = new NewList("b");
        list1.merge(list2);
        Assert.assertEquals((Object)"a;b;c;e", (Object)list1.toString());
        list2 = new NewList("a;c");
        list1.merge(list2);
        Assert.assertEquals((Object)"a;b;c;e", (Object)list1.toString());
    }

    public void testLessThan() {
        NewList list1 = new NewList("a");
        NewList list2 = new NewList("a");
        Assert.assertTrue((boolean)list1.lessThanOrEquals(list2));
        list1 = new NewList("a;b");
        list2 = new NewList("a");
        Assert.assertTrue((boolean)list2.lessThanOrEquals(list1));
        list1 = new NewList("a;b;d");
        list2 = new NewList("a;d");
        Assert.assertTrue((boolean)list2.lessThanOrEquals(list1));
        Assert.assertFalse((boolean)list1.lessThanOrEquals(list2));
        list1 = new NewList("a");
        list2 = new NewList("b");
        Assert.assertFalse((boolean)list1.lessThanOrEquals(list2));
    }
}

