/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.DefaultObserver;
import icecaptools.MethodOrFieldDesc;
import icecaptools.compiler.DefaultMethodObserver;
import icecaptools.compiler.VirtualTable;
import icecaptools.conversion.Converter;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;
import org.apache.bcel.util.SyntheticRepository;
import org.junit.Assert;
import org.junit.Test;
import test.icecaptools.DefaultCompilationRegistry;

public class TestConverter {
    @Test
    public void testCreateVTable() throws Exception {
        Converter converter = new Converter(System.out, new DefaultMethodObserver(), new DefaultCompilationRegistry(), false);
        ClassPath classPath = new ClassPath("C:\\home\\workspace\\icecaptools\\bin");
        SyntheticRepository repository = SyntheticRepository.getInstance((ClassPath)classPath);
        org.apache.bcel.Repository.setRepository((Repository)repository);
        TestObserver observer = new TestObserver();
        converter.setObserver(observer);
        VirtualTable vtableSub2 = VirtualTable.createVTable("test.icecaptools.minitests.Sub2", observer);
        VirtualTable vtableSub6 = VirtualTable.createVTable("test.icecaptools.minitests.Sub6", observer);
        MethodOrFieldDesc methodDesc = new MethodOrFieldDesc("test.icecaptools.minitests.Sub2", "foo", "()V");
        short index1 = vtableSub2.getIndexOf(methodDesc);
        methodDesc = new MethodOrFieldDesc("test.icecaptools.minitests.Sub6", "foo", "()V");
        short index2 = vtableSub6.getIndexOf(methodDesc);
        Assert.assertEquals((long)index1, (long)index2);
    }

    @Test
    public void testBug1() {
        ClassPath classPath = new ClassPath("C:\\home\\workspace\\icecaptools\\bin");
        SyntheticRepository repository = SyntheticRepository.getInstance((ClassPath)classPath);
        org.apache.bcel.Repository.setRepository((Repository)repository);
        try {
            JavaClass clazz = org.apache.bcel.Repository.lookupClass((String)"java.net.InetAddress");
            TestObserver observer = new TestObserver();
            Converter converter = new Converter(System.out, new DefaultMethodObserver(), new DefaultCompilationRegistry(), false);
            converter.setObserver(observer);
            converter.convertByteCode(null, clazz, "<clinit>", "()V", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    @Test
    public void testBug2() {
        ClassPath classPath = new ClassPath("C:\\home\\workspace\\icecaptools\\bin");
        SyntheticRepository repository = SyntheticRepository.getInstance((ClassPath)classPath);
        org.apache.bcel.Repository.setRepository((Repository)repository);
        try {
            JavaClass clazz = org.apache.bcel.Repository.lookupClass((String)"java.util.ResourceBundle");
            TestObserver observer = new TestObserver();
            Converter converter = new Converter(System.out, new DefaultMethodObserver(), new DefaultCompilationRegistry(), false);
            converter.setObserver(observer);
            converter.convertByteCode(null, clazz, "getClassContext", "()[Ljava/lang/Class;", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    public static class TestObserver
    extends DefaultObserver {
        @Override
        public boolean isMethodUsed(String className, String targetMethodName, String targetMethodSignature) {
            return true;
        }
    }
}

