/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.BNode;
import icecaptools.BasicBNode;
import icecaptools.stackanalyser.ProducerConsumerCellInfo;
import icecaptools.stackanalyser.ProducerConsumerStack;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class TestAnnotationStack {
    @Test
    public void testAnnotationStack1() {
        ProducerConsumerStack stack = new ProducerConsumerStack();
        BasicBNode testNode = new BasicBNode(0, "locationClass", "locationMethod", "locationMethodSignature");
        try {
            stack.push(testNode);
            stack.push(testNode);
            stack.push(testNode);
            stack.push(testNode);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertEquals((long)4L, (long)stack.size());
    }

    @Test
    public void testAnnotationStack2() {
        ProducerConsumerStack stack = new ProducerConsumerStack();
        BasicBNode testNode1 = new BasicBNode(0, "locationClass", "locationMethod", "locationMethodSignature");
        try {
            stack.push(testNode1);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        ProducerConsumerCellInfo cellInfo = stack.getCell(0);
        ArrayList<BNode> producers = cellInfo.getProducers();
        Assert.assertEquals((long)1L, (long)producers.size());
        Assert.assertEquals((Object)testNode1, (Object)producers.get(0));
    }

    @Test
    public void testAnnotationStack4() {
        BasicBNode testNode1 = new BasicBNode(0, "locationClass", "locationMethod", "locationMethodSignature");
        ProducerConsumerStack entryStack = new ProducerConsumerStack();
        try {
            entryStack.push(testNode1);
            entryStack.push(testNode1);
            entryStack.push(testNode1);
            ProducerConsumerStack exitStack = entryStack.copy();
            Assert.assertFalse((entryStack == exitStack ? 1 : 0) != 0);
            Assert.assertTrue((entryStack.size() == exitStack.size() ? 1 : 0) != 0);
            int i = 0;
            while (i < entryStack.size()) {
                ProducerConsumerCellInfo right;
                ProducerConsumerCellInfo left = entryStack.getCell(i);
                Assert.assertFalse((left == (right = exitStack.getCell(i)) ? 1 : 0) != 0);
                ArrayList<BNode> leftProducers = left.getProducers();
                ArrayList<BNode> rightProducers = right.getProducers();
                Assert.assertTrue((leftProducers.size() == rightProducers.size() ? 1 : 0) != 0);
                Assert.assertTrue((leftProducers.size() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((leftProducers.get(0) == rightProducers.get(0) ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    @Test
    public void testAnnotationStack5() {
        BasicBNode testNode1 = new BasicBNode(0, "locationClass", "locationMethod", "locationMethodSignature");
        BasicBNode testNode2 = new BasicBNode(0, "locationClass", "locationMethod", "locationMethodSignature");
        ProducerConsumerStack entryStack1 = new ProducerConsumerStack();
        ProducerConsumerStack entryStack2 = new ProducerConsumerStack();
        try {
            entryStack1.push(testNode1);
            entryStack1.push(testNode2);
            entryStack2.push(testNode1);
            entryStack2.push(testNode2);
            entryStack1.merge(entryStack2);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        int count = 0;
        int i = 0;
        while (i < entryStack1.size()) {
            ProducerConsumerCellInfo cell = entryStack1.getCell(i);
            ArrayList<BNode> producers = cell.getProducers();
            Assert.assertTrue((producers.size() == 1 ? 1 : 0) != 0);
            if (producers.get(0) == testNode1) {
                ++count;
            } else if (producers.get(0) == testNode2) {
                count += 2;
            }
            ++i;
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testAnnotationStack6() {
        boolean contuinueAnalysis;
        BasicBNode testNode1 = new BasicBNode(0, "locationClass", "locationMethod", "locationMethodSignature");
        BasicBNode testNode2 = new BasicBNode(1, "locationClass", "locationMethod", "locationMethodSignature");
        ProducerConsumerStack entryStack1 = new ProducerConsumerStack();
        ProducerConsumerStack entryStack2 = new ProducerConsumerStack();
        try {
            entryStack1.push(testNode1);
            entryStack2.push(testNode2);
            contuinueAnalysis = entryStack1.merge(entryStack2);
            Assert.assertTrue((boolean)contuinueAnalysis);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        entryStack1 = new ProducerConsumerStack();
        entryStack2 = new ProducerConsumerStack();
        try {
            entryStack1.push(testNode1);
            entryStack2.push(testNode1);
            contuinueAnalysis = entryStack1.merge(entryStack2);
            Assert.assertFalse((boolean)contuinueAnalysis);
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }
}

