/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.stackanalyser;

import icecaptools.BNode;
import icecaptools.stackanalyser.ProducerConsumerCellInfo;
import icecaptools.stackanalyser.ProducerConsumerNodeInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public class ProducerConsumerStack {
    private Stack<ProducerConsumerCellInfo> stack = new Stack();

    public void push(BNode producer) throws Exception {
        ProducerConsumerCellInfo cell = new ProducerConsumerCellInfo();
        cell.addProducer(producer);
        this.stack.push(cell);
    }

    public ProducerConsumerCellInfo pop(BNode consumer) throws Exception {
        ProducerConsumerCellInfo cell = this.stack.pop();
        ArrayList<BNode> producers = cell.getProducers();
        int i = 0;
        while (i < producers.size()) {
            BNode producer = producers.get(i);
            ProducerConsumerNodeInfo aInfo = producer.getAinfo();
            aInfo.addConsumer(this.stack.size(), consumer);
            ++i;
        }
        return cell;
    }

    public void addConsumer(int i, BNode consumer) throws Exception {
        ((ProducerConsumerCellInfo)this.stack.get(i)).addConsumer(consumer);
    }

    public ProducerConsumerStack copy() throws Exception {
        ProducerConsumerStack newStack = new ProducerConsumerStack();
        int i = 0;
        while (i < this.stack.size()) {
            ProducerConsumerCellInfo src = (ProducerConsumerCellInfo)this.stack.get(i);
            ProducerConsumerCellInfo dst = new ProducerConsumerCellInfo();
            for (BNode producer : src.getProducers()) {
                dst.addProducer(producer);
            }
            BNode consumer = src.getConsumer();
            dst.addConsumer(consumer);
            newStack.stack.push(dst);
            ++i;
        }
        return newStack;
    }

    public boolean merge(ProducerConsumerStack other) throws Exception {
        boolean changes = false;
        int i = 0;
        while (i < this.stack.size()) {
            ProducerConsumerCellInfo otherCellInfo = other.getCell(i);
            ProducerConsumerCellInfo thisCellInfo = this.getCell(i);
            for (BNode producer : otherCellInfo.getProducers()) {
                changes |= thisCellInfo.addProducer(producer);
            }
            BNode consumer = otherCellInfo.getConsumer();
            thisCellInfo.addConsumer(consumer);
            ++i;
        }
        return changes;
    }

    public int size() {
        return this.stack.size();
    }

    public ProducerConsumerCellInfo getCell(int i) {
        return (ProducerConsumerCellInfo)this.stack.get(i);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.stack.size() > 0) {
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                buffer.append(((ProducerConsumerCellInfo)iterator.next()).toString());
                buffer.append('\n');
            }
        } else {
            buffer.append("---");
        }
        return buffer.toString();
    }

    public ProducerConsumerCellInfo peek() {
        return this.stack.peek();
    }
}

