/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.stackanalyser;

import icecaptools.BNode;
import icecaptools.BasicBNode;
import icecaptools.ByteCodeStream;
import icecaptools.ClassfileUtils;
import icecaptools.FieldAccessBNode;
import icecaptools.HackInterfaceMethodCallBNode;
import icecaptools.IcecapIterator;
import icecaptools.JavaArrayClass;
import icecaptools.LDCBNode;
import icecaptools.MethodCallBNode;
import icecaptools.MethodEntryPoints;
import icecaptools.RawByteCodes;
import icecaptools.RuntimeMethodCallBNode;
import icecaptools.stackanalyser.ProducerConsumerNodeInfo;
import icecaptools.stackanalyser.ProducerConsumerStack;
import icecaptools.stackanalyser.StackReferencesAnalyser;
import java.util.Iterator;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class ProducerConsumerAnalyser {
    public static void annotate(MethodEntryPoints entryPoints) throws Exception {
        BNode mainEntryPoint = entryPoints.getMainEntryPoint();
        ProducerConsumerAnalyser.analyseNode(mainEntryPoint, new ProducerConsumerStack());
        IcecapIterator<BNode> handlers = entryPoints.getHandlerEntryPoints();
        while (handlers.hasNext()) {
            ProducerConsumerStack exitStack = new ProducerConsumerStack();
            BasicBNode aloadBNode = new BasicBNode(0, "exceptionHandler", "entryPoint", "");
            byte[] byArray = new byte[2];
            byArray[0] = 25;
            byte[] rawBytes = byArray;
            aloadBNode.setRawBytes(rawBytes);
            exitStack.push(aloadBNode);
            ProducerConsumerNodeInfo aInfo = aloadBNode.getAinfo();
            aInfo.entryStack = new ProducerConsumerStack();
            aInfo.exitStack = exitStack;
            BNode nextHandler = handlers.next();
            ProducerConsumerAnalyser.analyseNode(nextHandler, exitStack);
        }
    }

    public static void analyseNode(BNode node, ProducerConsumerStack entryStack) throws Exception {
        boolean continueAnalysis;
        ProducerConsumerNodeInfo aInfo = node.getAinfo();
        if (aInfo.entryStack == null) {
            aInfo.entryStack = entryStack;
            continueAnalysis = true;
        } else {
            continueAnalysis = aInfo.entryStack.merge(entryStack);
        }
        ProducerConsumerStack exitStack = ProducerConsumerAnalyser.handleNode(node, entryStack.copy());
        if (aInfo.exitStack == null) {
            aInfo.exitStack = exitStack;
            continueAnalysis = true;
        } else {
            continueAnalysis |= aInfo.exitStack.merge(exitStack);
        }
        if (continueAnalysis) {
            Iterator<BNode> children = node.getChildren();
            while (children.hasNext()) {
                BNode child = children.next();
                if (child instanceof RuntimeMethodCallBNode || child instanceof HackInterfaceMethodCallBNode) continue;
                ProducerConsumerAnalyser.analyseNode(child, aInfo.exitStack.copy());
            }
        }
    }

    private static ProducerConsumerStack handleNode(BNode node, ProducerConsumerStack stack) throws Exception {
        byte code = node.getOpCode();
        switch (code) {
            case 0: {
                break;
            }
            case 1: {
                stack.push(node);
                break;
            }
            case 2: {
                stack.push(node);
                break;
            }
            case 3: {
                stack.push(node);
                break;
            }
            case 4: {
                stack.push(node);
                break;
            }
            case 5: {
                stack.push(node);
                break;
            }
            case 6: {
                stack.push(node);
                break;
            }
            case 7: {
                stack.push(node);
                break;
            }
            case 8: {
                stack.push(node);
                break;
            }
            case 9: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 10: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 11: {
                stack.push(node);
                break;
            }
            case 12: {
                stack.push(node);
                break;
            }
            case 13: {
                stack.push(node);
                break;
            }
            case 14: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 15: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 16: {
                stack.push(node);
                break;
            }
            case 17: {
                stack.push(node);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                LDCBNode ldcNode = (LDCBNode)node;
                switch (ldcNode.constant.getType()) {
                    case 4: 
                    case 5: {
                        stack.push(node);
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: {
                        stack.push(node);
                    }
                }
                break;
            }
            case 21: {
                stack.push(node);
                break;
            }
            case 22: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 23: {
                stack.push(node);
                break;
            }
            case 24: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 25: {
                stack.push(node);
                break;
            }
            case 26: {
                stack.push(node);
                break;
            }
            case 27: {
                stack.push(node);
                break;
            }
            case 28: {
                stack.push(node);
                break;
            }
            case 29: {
                stack.push(node);
                break;
            }
            case 30: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 31: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 32: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 33: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 34: {
                stack.push(node);
                break;
            }
            case 35: {
                stack.push(node);
                break;
            }
            case 36: {
                stack.push(node);
                break;
            }
            case 37: {
                stack.push(node);
                break;
            }
            case 38: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 39: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 40: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 41: {
                stack.push(node);
                stack.push(node);
                break;
            }
            case 42: {
                stack.push(node);
                break;
            }
            case 43: {
                stack.push(node);
                break;
            }
            case 44: {
                stack.push(node);
                break;
            }
            case 45: {
                stack.push(node);
                break;
            }
            case 46: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 47: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 48: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 49: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 50: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 51: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 52: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 53: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 54: {
                stack.pop(node);
                break;
            }
            case 55: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 56: {
                stack.pop(node);
                break;
            }
            case 57: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 58: {
                stack.pop(node);
                break;
            }
            case 59: {
                stack.pop(node);
                break;
            }
            case 60: {
                stack.pop(node);
                break;
            }
            case 61: {
                stack.pop(node);
                break;
            }
            case 62: {
                stack.pop(node);
                break;
            }
            case 63: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 64: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 65: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 66: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 67: {
                stack.pop(node);
                break;
            }
            case 68: {
                stack.pop(node);
                break;
            }
            case 69: {
                stack.pop(node);
                break;
            }
            case 70: {
                stack.pop(node);
                break;
            }
            case 71: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 72: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 73: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 74: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 75: {
                stack.pop(node);
                break;
            }
            case 76: {
                stack.pop(node);
                break;
            }
            case 77: {
                stack.pop(node);
                break;
            }
            case 78: {
                stack.pop(node);
                break;
            }
            case 79: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 80: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 81: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 82: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 83: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 84: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 85: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 86: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 87: {
                stack.pop(node);
                break;
            }
            case 88: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case 89: {
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 90: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 91: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 92: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 93: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                stack.push(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 94: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                stack.push(node);
                stack.push(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 95: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 96: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 97: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 98: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 99: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 100: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 101: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 102: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 103: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 104: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 105: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 106: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 107: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 108: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 109: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 110: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 111: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 112: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 113: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 114: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 115: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 116: {
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 117: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 118: {
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 119: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 120: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 121: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 122: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 123: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 124: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 125: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case 126: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case 127: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case -128: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -126: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -127: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case -125: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case -124: {
                break;
            }
            case -123: {
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case -122: {
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -121: {
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case -120: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -119: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -118: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case -117: {
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -116: {
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case -115: {
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case -114: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -113: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                stack.push(node);
                break;
            }
            case -112: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -111: {
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -110: {
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -109: {
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -108: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -107: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -106: {
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -105: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -104: {
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -103: {
                stack.pop(node);
                break;
            }
            case -102: {
                stack.pop(node);
                break;
            }
            case -101: {
                stack.pop(node);
                break;
            }
            case -100: {
                stack.pop(node);
                break;
            }
            case -99: {
                stack.pop(node);
                break;
            }
            case -98: {
                stack.pop(node);
                break;
            }
            case -97: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case -96: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case -95: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case -94: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case -93: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case -92: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case -91: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case -90: {
                stack.pop(node);
                stack.pop(node);
                break;
            }
            case -89: {
                break;
            }
            case -88: {
                break;
            }
            case -87: {
                break;
            }
            case -86: {
                stack.pop(node);
                break;
            }
            case -85: {
                stack.pop(node);
                break;
            }
            case -83: 
            case -81: {
                stack.pop(node);
            }
            case -84: 
            case -82: 
            case -80: {
                stack.pop(node);
            }
            case -79: {
                break;
            }
            case -78: {
                FieldAccessBNode fieldAccess = (FieldAccessBNode)node;
                ProducerConsumerAnalyser.handlePutGetField(stack, fieldAccess);
                break;
            }
            case -77: {
                FieldAccessBNode fieldAccess = (FieldAccessBNode)node;
                ProducerConsumerAnalyser.handlePutGetField(stack, fieldAccess);
                break;
            }
            case -76: {
                FieldAccessBNode fieldAccess = (FieldAccessBNode)node;
                ProducerConsumerAnalyser.handlePutGetField(stack, fieldAccess);
                break;
            }
            case -75: {
                FieldAccessBNode fieldAccess = (FieldAccessBNode)node;
                ProducerConsumerAnalyser.handlePutGetField(stack, fieldAccess);
                break;
            }
            case -70: {
                stack.push(node);
                break;
            }
            case -74: {
                MethodCallBNode methodCall = (MethodCallBNode)node;
                ProducerConsumerAnalyser.handleInvoke(stack, methodCall, false);
                break;
            }
            case -73: {
                MethodCallBNode methodCall = (MethodCallBNode)node;
                ProducerConsumerAnalyser.handleInvoke(stack, methodCall, false);
                break;
            }
            case -72: {
                MethodCallBNode methodCall = (MethodCallBNode)node;
                ProducerConsumerAnalyser.handleInvoke(stack, methodCall, false);
                break;
            }
            case -71: {
                MethodCallBNode methodCall = (MethodCallBNode)node;
                ProducerConsumerAnalyser.handleInvoke(stack, methodCall, true);
                break;
            }
            case -69: {
                stack.push(node);
                break;
            }
            case -67: {
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -68: {
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -66: {
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -65: {
                stack.pop(node);
                break;
            }
            case -64: {
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -63: {
                stack.pop(node);
                stack.push(node);
                break;
            }
            case -62: {
                stack.pop(node);
                break;
            }
            case -61: {
                stack.pop(node);
                break;
            }
            case -60: {
                RawByteCodes.Raw_wide wide = new RawByteCodes.Raw_wide();
                ByteCodeStream stream = new ByteCodeStream();
                stream.init(node.getRawBytes());
                wide.read(code, stream);
                switch (wide.actualOpcode) {
                    case 21: 
                    case 23: {
                        stack.push(node);
                        break;
                    }
                    case 25: {
                        stack.push(node);
                        break;
                    }
                    case 22: 
                    case 24: {
                        stack.push(node);
                        stack.push(node);
                        break;
                    }
                    case 54: 
                    case 56: {
                        stack.pop(node);
                        stack.pop(node);
                        break;
                    }
                    case 58: {
                        stack.pop(node);
                        break;
                    }
                    case 55: 
                    case 57: {
                        stack.pop(node);
                        stack.pop(node);
                    }
                }
                break;
            }
            case -59: {
                RawByteCodes.Raw_multianewarray currentRawBytecode = new RawByteCodes.Raw_multianewarray();
                ByteCodeStream stream = new ByteCodeStream();
                stream.init(node.getRawBytes());
                stream.get();
                currentRawBytecode.read(code, stream);
                RawByteCodes.Raw_multianewarray multi = currentRawBytecode;
                int dimensions = multi.count;
                while (dimensions > 0) {
                    stack.pop(node);
                    --dimensions;
                }
                stack.push(node);
                break;
            }
            case -58: {
                stack.pop(node);
                break;
            }
            case -57: {
                stack.pop(node);
                break;
            }
            case -56: {
                break;
            }
            case -55: {
                stack.push(node);
                break;
            }
            default: {
                throw new Exception("Unknown byte code [" + code + "]");
            }
        }
        return stack;
    }

    private static void handleInvoke(ProducerConsumerStack stack, MethodCallBNode methodCall, boolean isInterfaceInvocation) throws Exception {
        String className = methodCall.getClassName();
        String methodName = methodCall.getMethodName();
        String methodSig = methodCall.getMethodSig();
        String class_name = JavaArrayClass.isArrayClass(className) && methodName.getBytes().equals("clone") && methodSig.getBytes().equals("()Ljava/lang/Object;") ? "java.lang.Object" : className;
        JavaClass clazz = Repository.lookupClass((String)class_name);
        Method method = isInterfaceInvocation ? ClassfileUtils.findDeclaringInterface(clazz, methodName, methodSig).getMethod() : ClassfileUtils.findMethodInClassHierarchy(clazz, methodName, methodSig).getMethod();
        ProducerConsumerAnalyser.popArgs(stack, method, methodCall);
        if (methodCall.getOpCode() != -72) {
            stack.pop(methodCall);
        }
        ProducerConsumerAnalyser.pushReturnValue(stack, method, methodCall);
    }

    private static void popArgs(ProducerConsumerStack stack, Method method, MethodCallBNode methodCall) throws Exception {
        Type[] args = method.getArgumentTypes();
        int i = args.length;
        while (i > 0) {
            Type currentType = args[i - 1];
            ProducerConsumerAnalyser.pushPopType(stack, currentType, true, methodCall);
            --i;
        }
        methodCall.setNumArgs(args.length);
    }

    /*
     * Unable to fully structure code
     */
    private static void pushPopType(ProducerConsumerStack stack, Type currentType, boolean pop, MethodCallBNode methodCall) throws Exception {
        if (currentType instanceof BasicType) {
            isRef = false;
        } else if (currentType instanceof ReferenceType) {
            isRef = true;
        } else {
            throw new Exception("Unknown field type");
        }
        size = currentType.getSize();
        if (size != 0) ** GOTO lbl24
        throw new Exception("Zero size field");
lbl-1000:
        // 1 sources

        {
            if (isRef) {
                if (pop) {
                    stack.pop(methodCall);
                } else {
                    stack.push(methodCall);
                }
            } else if (pop) {
                stack.pop(methodCall);
            } else {
                stack.push(methodCall);
            }
            --size;
lbl24:
            // 2 sources

            ** while (size > 0)
        }
lbl25:
        // 1 sources

    }

    private static void pushReturnValue(ProducerConsumerStack stack, Method method, MethodCallBNode methodCall) throws Exception {
        Type returnType = method.getReturnType();
        if (returnType.getSize() > 0) {
            ProducerConsumerAnalyser.pushPopType(stack, returnType, false, methodCall);
        }
    }

    private static void handlePutGetField(ProducerConsumerStack stack, FieldAccessBNode node) throws Exception {
        Field field = StackReferencesAnalyser.findField(node.getClassName(), node.getFieldName(), node.getSignature());
        boolean isRef = StackReferencesAnalyser.fieldIsRef(field);
        int size = field.getType().getSize();
        node.setSize(size);
        if (size == 0) {
            throw new Exception("Zero size field");
        }
        if (node.getOpCode() == -76) {
            stack.pop(node);
        }
        while (size > 0) {
            if (isRef) {
                if (node.getOpCode() == -75 || node.getOpCode() == -77) {
                    stack.pop(node);
                } else if (node.getOpCode() == -76 || node.getOpCode() == -78) {
                    stack.push(node);
                }
            } else if (node.getOpCode() == -75 || node.getOpCode() == -77) {
                stack.pop(node);
            } else if (node.getOpCode() == -76 || node.getOpCode() == -78) {
                stack.push(node);
            }
            --size;
        }
        if (node.getOpCode() == -75) {
            stack.pop(node);
        }
    }
}

