/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching.uart;

import icecaptools.debugging.DebugChannel;
import icecaptools.launching.arduino.ProcessOutputReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IProgressMonitor;

public class UARTChannel
extends DebugChannel {
    private ProcessOutput eventStream;
    private ProcessOutput responseStream;
    private ProcessOutput stdoutStream;
    private OutputStream requestStream;
    private ProcessOutputReaderThread reader;

    public UARTChannel(InputStream input, OutputStream output) {
        this.requestStream = new InputToProcessStream(output);
        this.eventStream = new ProcessOutput();
        this.responseStream = new ProcessOutput();
        this.stdoutStream = new ProcessOutput();
        this.reader = new ProcessOutputReaderThread(input);
        this.reader.start();
    }

    @Override
    public void connectToTarget(IProgressMonitor monitor) throws UnknownHostException, IOException {
    }

    @Override
    public InputStream getEventChannel() throws IOException {
        return this.eventStream;
    }

    public InputStream getStdoutChannel() throws IOException {
        return this.stdoutStream;
    }

    @Override
    public OutputStream getRequestOutputStream() throws IOException {
        return this.requestStream;
    }

    @Override
    public InputStream getRequestInputStream() throws IOException {
        return this.responseStream;
    }

    @Override
    public void disconnectFromTarget() throws IOException {
        this.reader.stopReading();
        try {
            this.reader.join();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private static class InputToProcessStream
    extends OutputStream {
        private OutputStream inputToProcess;

        public InputToProcessStream(OutputStream output) {
            this.inputToProcess = output;
        }

        @Override
        public void write(int b) throws IOException {
            this.inputToProcess.write(b);
            this.inputToProcess.flush();
        }
    }

    private static class ProcessOutput
    extends ProcessOutputReader {
        private ProcessOutput() {
        }

        public void putToQueue(byte b) {
            this.queue.add(b);
        }
    }

    private class ProcessOutputReaderThread
    extends Thread {
        private InputStream outputFromProcess;
        private boolean stop;

        public ProcessOutputReaderThread(InputStream input) {
            this.outputFromProcess = input;
            this.stop = false;
        }

        @Override
        public void run() {
            boolean eventChannelClosed = false;
            boolean responseChannelClosed = false;
            boolean stdoutChannelClosed = false;
            while (!this.stop) {
                try {
                    int tag = this.outputFromProcess.read();
                    int c = this.outputFromProcess.read();
                    switch (tag) {
                        case 1: {
                            UARTChannel.this.eventStream.putToQueue((byte)c);
                            eventChannelClosed = c == -1;
                            break;
                        }
                        case 2: {
                            UARTChannel.this.responseStream.putToQueue((byte)c);
                            responseChannelClosed = c == -1;
                            break;
                        }
                        case 3: {
                            UARTChannel.this.stdoutStream.putToQueue((byte)c);
                            stdoutChannelClosed = c == -1;
                        }
                    }
                    this.stop = eventChannelClosed && responseChannelClosed && stdoutChannelClosed;
                }
                catch (IOException iOException) {
                    this.stop = true;
                }
            }
        }

        public void stopReading() {
            this.stop = true;
        }
    }
}

