/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching.arduino;

import icecaptools.IcecapEclipseProgressMonitor;
import icecaptools.launching.AbstractHVMPOSIXLaunchConfigurationDelegate;
import icecaptools.launching.ShellCommand;
import icecaptools.launching.arduino.ArduinoLauncherTab;
import icecaptools.launching.arduino.ArduinoProcess;
import java.io.PrintStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.widgets.Shell;

public class ArduinoProcessWindowsHost
extends ArduinoProcess {
    public ArduinoProcessWindowsHost(String sourceFolder) {
        super(sourceFolder);
    }

    @Override
    protected ArduinoProcess startProcessOnTarget(ILaunch launch, ILaunchConfiguration configuration, StringBuffer path, PrintStream consoleOutputStream, IProgressMonitor monitor, Shell shell) throws CoreException {
        this.processOutputPort = configuration.getAttribute("COMPORT", ArduinoLauncherTab.getDefaultComPort());
        String command = "avrdude -F -V -c arduino -p ATMEGA328P -P " + this.processOutputPort + " -b 115200 -U flash:w:main.hex";
        int result = ShellCommand.executeCommand(command, consoleOutputStream, true, this.sourceFolder.toString(), null, 20, new IcecapEclipseProgressMonitor(monitor));
        if (result == 0) {
            result = this.connectProcessOutput(consoleOutputStream);
            if (result == 0) {
                return this;
            }
            AbstractHVMPOSIXLaunchConfigurationDelegate.notify("Could not connect to process output (" + this.processOutputPort + ")\nIs Arduino plugged in?");
            return null;
        }
        return null;
    }
}

