/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching.arduino;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import icecaptools.debugging.DebugChannel;
import icecaptools.launching.arduino.ProcessOutputReader;
import icecaptools.launching.uart.InputParser;
import icecaptools.launching.uart.PortReader;
import icecaptools.launching.uart.Serial;
import icecaptools.launching.uart.UARTChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.TooManyListenersException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.widgets.Shell;

public abstract class ArduinoProcess
extends Process {
    private InputStream errorStreamFromProcess;
    private InputStream outputStreamFromProcess = new DummyInputStream();
    private OutputStream inputStreamToProcess = new DummyOutputStream();
    private PortReader pReader;
    protected String processOutputPort;
    protected String sourceFolder;

    public ArduinoProcess(String sourceFolder) {
        this.errorStreamFromProcess = new DummyInputStream();
        this.sourceFolder = sourceFolder;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.inputStreamToProcess;
    }

    @Override
    public InputStream getInputStream() {
        return this.outputStreamFromProcess;
    }

    @Override
    public InputStream getErrorStream() {
        return this.errorStreamFromProcess;
    }

    @Override
    public int waitFor() throws InterruptedException {
        if (this.pReader != null) {
            this.pReader.join();
        }
        return 0;
    }

    @Override
    public int exitValue() {
        if (this.pReader.running()) {
            throw new IllegalThreadStateException();
        }
        return 0;
    }

    @Override
    public void destroy() {
        this.pReader.stopPort();
    }

    public int connectProcessOutput(PrintStream consoleOutputStream) {
        Iterator<String> availablePorts = Serial.getAvailablePorts();
        while (availablePorts.hasNext()) {
            String port = availablePorts.next();
            if (!port.equals(this.processOutputPort)) continue;
            try {
                this.outputStreamFromProcess = new UARTProcessOutput();
                this.pReader = new PortReader(this.processOutputPort, (UARTProcessOutput)this.outputStreamFromProcess);
                this.inputStreamToProcess = new UARTProcessInput();
                consoleOutputStream.println("Starting port reader");
                this.pReader.startPort();
            }
            catch (NoSuchPortException noSuchPortException) {
                consoleOutputStream.println("NoSuchPortException");
                return -1;
            }
            catch (PortInUseException portInUseException) {
                consoleOutputStream.println("PortInUseException");
                return -1;
            }
            catch (IOException iOException) {
                consoleOutputStream.println("IOException");
                return -1;
            }
            catch (TooManyListenersException tooManyListenersException) {
                consoleOutputStream.println("TooManyListenersException");
                return -1;
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                consoleOutputStream.println("UnsupportedCommOperationException");
                return -1;
            }
        }
        if (this.pReader == null) {
            consoleOutputStream.println("Unable to read from Arduino");
            return -1;
        }
        return 0;
    }

    public void setInputStream(InputStream stdoutChannel) {
        this.outputStreamFromProcess = stdoutChannel;
    }

    protected abstract ArduinoProcess startProcessOnTarget(ILaunch var1, ILaunchConfiguration var2, StringBuffer var3, PrintStream var4, IProgressMonitor var5, Shell var6) throws CoreException;

    public DebugChannel getChannel() throws IOException {
        UARTChannel channel = new UARTChannel(this.getInputStream(), this.getOutputStream());
        this.setInputStream(channel.getStdoutChannel());
        return channel;
    }

    private class DummyInputStream
    extends InputStream {
        private DummyInputStream() {
        }

        @Override
        public int read() throws IOException {
            while (ArduinoProcess.this.pReader.running()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return -1;
        }
    }

    private static class DummyOutputStream
    extends OutputStream {
        private DummyOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    public static class InputStreamGenerator
    extends InputStream {
        private OutputStreamParser commandOutputParser;
        private String passwd;
        private int top;

        public InputStreamGenerator(OutputStreamParser commandOutputParser, String passwd) {
            this.commandOutputParser = commandOutputParser;
            this.passwd = passwd;
            this.top = 0;
        }

        @Override
        public int read() throws IOException {
            while (!this.commandOutputParser.getReady()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.top < this.passwd.length()) {
                return this.passwd.charAt(this.top++);
            }
            return -1;
        }
    }

    public static class OutputStreamParser
    extends OutputStream {
        private PrintStream consoleOutputStream;
        private boolean ready;

        public OutputStreamParser(PrintStream consoleOutputStream) {
            this.consoleOutputStream = consoleOutputStream;
            this.ready = false;
        }

        @Override
        public void write(int b) throws IOException {
            this.consoleOutputStream.write(b);
            if (b == 58) {
                this.ready = true;
            }
        }

        public boolean getReady() {
            return this.ready;
        }
    }

    private class UARTProcessInput
    extends OutputStream {
        private UARTProcessInput() {
        }

        @Override
        public void write(int b) throws IOException {
            ArduinoProcess.this.pReader.parseByte((byte)b);
            ArduinoProcess.this.pReader.flush();
        }
    }

    private static class UARTProcessOutput
    extends ProcessOutputReader
    implements InputParser {
        private UARTProcessOutput() {
        }

        @Override
        public InputParser parseByte(byte b) throws IOException, UnsupportedCommOperationException {
            this.queue.add(b);
            if (b != -1) {
                return this;
            }
            return null;
        }
    }
}

