/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching;

import icecaptools.CompilationSequence;
import icecaptools.ConverterJob;
import icecaptools.MethodOrFieldDesc;
import icecaptools.compiler.ByteCodePatcher;
import icecaptools.debugging.HVMStackFrame;
import java.io.File;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;

public class HVMSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    public void init(ISourceLookupDirector director) {
        super.init(director);
    }

    public String getSourceName(Object object) throws CoreException {
        if (object instanceof HVMStackFrame) {
            ByteCodePatcher patcher;
            MethodOrFieldDesc desc;
            HVMStackFrame frame = (HVMStackFrame)((Object)object);
            CompilationSequence compilationSequence = ConverterJob.mostRecentSequence;
            if (compilationSequence != null && (desc = (patcher = compilationSequence.getPatcher()).getMethodDescriptor(frame.getMethodNumber())) != null) {
                try {
                    JavaClass clazz = Repository.lookupClass((String)desc.getClassName());
                    if (clazz != null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(clazz.getPackageName().replace('.', File.separatorChar));
                        buffer.append(File.separatorChar);
                        buffer.append(clazz.getSourceFileName());
                        return buffer.toString();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new CoreException(new IStatus(){
                        private static final String message = "Could not get source name";

                        public IStatus[] getChildren() {
                            return null;
                        }

                        public int getCode() {
                            return 4;
                        }

                        public Throwable getException() {
                            return new Exception(message);
                        }

                        public String getMessage() {
                            return message;
                        }

                        public String getPlugin() {
                            return DebugPlugin.getUniqueIdentifier();
                        }

                        public int getSeverity() {
                            return 4;
                        }

                        public boolean isMultiStatus() {
                            return false;
                        }

                        public boolean isOK() {
                            return false;
                        }

                        public boolean matches(int severityMask) {
                            return false;
                        }
                    });
                }
            }
        }
        return "???";
    }

    public void dispose() {
        super.dispose();
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        super.sourceContainersChanged(director);
    }
}

