/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class CommonLauncherTab
extends AbstractLaunchConfigurationTab {
    private static final String tabName = "Main";
    public static final String SOURCE_FOLDER = "SOURCE_FOLDER";
    protected Composite root;
    private Text sourceText;
    protected ILaunchConfigurationDialog lcd;
    protected Group sourceGroup;

    public void createControl(Composite parent) {
        this.root = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        this.root.setLayout((Layout)layout);
        this.sourceGroup = new Group(this.root, 4);
        this.sourceGroup.setText(this.getSourceGroupHeader());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100, -5);
        this.sourceGroup.setLayoutData((Object)formData);
        layout = new FormLayout();
        this.sourceGroup.setLayout((Layout)layout);
        Label sourceFolder = new Label((Composite)this.sourceGroup, 16384);
        sourceFolder.setText(this.getSourceLabelText());
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 10);
        sourceFolder.setLayoutData((Object)formData);
        Button select = new Button((Composite)this.sourceGroup, 8);
        select.setText("...");
        formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100, -5);
        select.setLayoutData((Object)formData);
        this.sourceText = new Text((Composite)this.sourceGroup, 2052);
        formData = new FormData();
        formData.left = new FormAttachment((Control)sourceFolder, 5);
        formData.top = new FormAttachment(0, 10);
        formData.right = new FormAttachment((Control)select, -5);
        this.sourceText.setLayoutData((Object)formData);
        this.sourceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonLauncherTab.this.lcd.updateButtons();
            }
        });
        select.addMouseListener((MouseListener)new SelectSourceFolderListener(select, this.sourceText));
    }

    protected abstract String getSourceLabelText();

    protected abstract String getSourceGroupHeader();

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SOURCE_FOLDER, "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String sourceFolder = configuration.getAttribute(SOURCE_FOLDER, "");
            if (sourceFolder.trim().length() > 0) {
                this.sourceText.setText(sourceFolder);
            }
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String folder = this.sourceText.getText();
        configuration.setAttribute(SOURCE_FOLDER, folder);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String folder = this.sourceText.getText();
        return folder != null && folder.trim().length() > 0;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        this.lcd = dialog;
    }

    public String getName() {
        return tabName;
    }

    private class SelectSourceFolderListener
    extends SelectSourceFolderOrFileListener {
        SelectSourceFolderListener(Button select, Text text) {
            super(select, text);
        }

        public void mouseUp(MouseEvent e) {
            DirectoryDialog dialog = new DirectoryDialog(this.select.getShell(), 4096);
            dialog.setText("Locate source folder");
            String filter = this.text.getText();
            if (filter != null && filter.trim().length() == 0) {
                filter = null;
            }
            dialog.setFilterPath(filter);
            String path = dialog.open();
            if (path == null) {
                return;
            }
            this.text.setText(path);
            CommonLauncherTab.this.lcd.updateButtons();
        }
    }

    protected static abstract class SelectSourceFolderOrFileListener
    implements MouseListener {
        protected Button select;
        protected Text text;

        SelectSourceFolderOrFileListener(Button select, Text text) {
            this.select = select;
            this.text = text;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }
    }
}

