/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching;

import icecaptools.IcecapEclipseProgressMonitor;
import icecaptools.actions.ConvertJavaFileAction;
import icecaptools.debugging.DebugChannel;
import icecaptools.debugging.HVMPOSIXDebugTarget;
import icecaptools.launching.ShellCommand;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractHVMPOSIXLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private static final int COMPILATION_TIMEOUT = 20;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Launch HVM application", 20);
        monitor.subTask("Retreiving launch parameters");
        String sourceFolder = configuration.getAttribute("SOURCE_FOLDER", "");
        if (sourceFolder.trim().length() > 0) {
            configuration.getAttribute("ENABLE_NATIVE_IMPLEMENTATION", false);
            configuration.getAttribute("IMPLEMENTATION_FILE", "");
            monitor.worked(1);
            monitor.subTask("clean up");
            StringBuffer path = new StringBuffer();
            path.append(sourceFolder);
            if (!sourceFolder.endsWith("" + File.separatorChar)) {
                path.append(File.separatorChar);
            }
            path.append("main.exe");
            try {
                File leftOver = new File(path.toString());
                if (leftOver.exists() && leftOver.isFile()) {
                    leftOver.delete();
                }
            }
            catch (Throwable throwable) {}
            StringBuffer compilerCommand = this.getCompilerCommand(configuration);
            int requestResponseChannel = -1;
            int eventChannel = -1;
            compilerCommand.append("-DJAVA_HEAP_SIZE=" + this.getHeapSize(configuration.getAttribute("HEAPSIZE", 0)) + " ");
            if (mode.equals("debug")) {
                requestResponseChannel = this.getRequestResponseChannel();
                eventChannel = this.getEventChannel();
                compilerCommand.append("-DENABLE_DEBUG -DREQUESTRESPONSECHANNEL=" + requestResponseChannel + " ");
                compilerCommand.append("-DEVENTCHANNEL=" + eventChannel + " ");
            }
            compilerCommand.append("classes.c icecapvm.c methodinterpreter.c methods.c gc.c print.c natives_allOS.c rom_heap.c allocation_point.c rom_access.c ");
            this.addTargetSpecificFiles(compilerCommand, configuration);
            compilerCommand.append(" -o main.exe");
            PrintStream consoleOutputStream = ConvertJavaFileAction.getConsolePrintStream();
            ConvertJavaFileAction.bringConsoleToFront(false);
            int exitValue = ShellCommand.executeCommand(compilerCommand.toString(), consoleOutputStream, true, sourceFolder, null, 20, new IcecapEclipseProgressMonitor(monitor));
            switch (exitValue) {
                case -2: {
                    this.processStartFailed(this.getCompilerExecutable());
                    break;
                }
                case -3: {
                    this.illegalWorkingDirectory(sourceFolder);
                    break;
                }
                case -1: {
                    this.processHanged(20);
                    break;
                }
                default: {
                    if (exitValue == 0) {
                        consoleOutputStream.println("Compilation succeeded");
                        monitor.subTask("Stripping executable");
                        this.stripExecutable(path, consoleOutputStream, sourceFolder, monitor);
                        monitor.subTask("Executing application");
                        Process process = this.startProcessOnTarget(launch, configuration, path, sourceFolder, consoleOutputStream, monitor);
                        if (process == null) break;
                        if (mode.equals("debug")) {
                            try {
                                DebugChannel channel = this.getChannel(process, requestResponseChannel, eventChannel, this.getTargetIPAddress(configuration));
                                IProcess p = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)"program");
                                HVMPOSIXDebugTarget target = new HVMPOSIXDebugTarget(launch, p, channel, monitor);
                                launch.addDebugTarget((IDebugTarget)target);
                            }
                            catch (Exception e) {
                                consoleOutputStream.println("Attaching to debug process failed: ");
                                consoleOutputStream.println(e.getMessage());
                                ConvertJavaFileAction.bringConsoleToFront(false);
                            }
                        } else {
                            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)"program");
                        }
                        return;
                    }
                    consoleOutputStream.println("Compilation failed for unknown reason :-(");
                    consoleOutputStream.println("Check the logs above.");
                }
            }
        }
        IStatus status = new IStatus(){
            private static final String message = "Could not launch application";

            public IStatus[] getChildren() {
                return null;
            }

            public int getCode() {
                return 4;
            }

            public Throwable getException() {
                return new Exception(message);
            }

            public String getMessage() {
                return message;
            }

            public String getPlugin() {
                return DebugPlugin.getUniqueIdentifier();
            }

            public int getSeverity() {
                return 4;
            }

            public boolean isMultiStatus() {
                return false;
            }

            public boolean isOK() {
                return false;
            }

            public boolean matches(int severityMask) {
                return false;
            }
        };
        throw new CoreException(status);
    }

    private void addTargetSpecificFiles(StringBuffer compilerCommand, ILaunchConfiguration configuration) throws CoreException {
        String implementationFile;
        boolean enableNatives = configuration.getAttribute("ENABLE_NATIVE_IMPLEMENTATION", false);
        if (enableNatives && (implementationFile = configuration.getAttribute("IMPLEMENTATION_FILE", "")) != null && implementationFile.trim().length() > 0) {
            compilerCommand.append(implementationFile.trim());
            compilerCommand.append(" ");
        }
        this.addAdditionalFiles(compilerCommand, configuration);
    }

    protected abstract int getEventChannel();

    protected abstract int getRequestResponseChannel();

    protected abstract DebugChannel getChannel(Process var1, int var2, int var3, String var4) throws IOException;

    protected abstract String getHeapSize(int var1);

    protected abstract String getTargetIPAddress(ILaunchConfiguration var1) throws CoreException;

    protected void stripExecutable(StringBuffer path, PrintStream consoleOutputStream, String sourceFolder, IProgressMonitor monitor) {
        ShellCommand.executeCommand(String.valueOf(this.getStripper()) + " " + path, consoleOutputStream, true, sourceFolder, null, 20, new IcecapEclipseProgressMonitor(monitor));
    }

    protected abstract String getStripper();

    protected abstract void addAdditionalFiles(StringBuffer var1, ILaunchConfiguration var2) throws CoreException;

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public static void notify(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = AbstractHVMPOSIXLaunchConfigurationDelegate.getShell();
                MessageDialog dialog = new MessageDialog(shell, "Icecap Tools", null, message, 1, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    private void processHanged(int compilationTimeout) {
        AbstractHVMPOSIXLaunchConfigurationDelegate.notify("Compilation did not finish within timeout (" + compilationTimeout + ") sec?");
    }

    private void illegalWorkingDirectory(String sourceFolder) {
        AbstractHVMPOSIXLaunchConfigurationDelegate.notify("Could not compile in folder:\n\n\t\t" + sourceFolder + "\n\nDoes this folder exist?");
    }

    private void processStartFailed(String compilerExecutable) {
        AbstractHVMPOSIXLaunchConfigurationDelegate.notify("Failed to compile executable\nIs the compiler '" + compilerExecutable + "' in your path?");
    }

    protected String getOptimizationLevel(ILaunchConfiguration configuration) throws CoreException {
        int optimLevel = configuration.getAttribute("GCC_OPTIMIZATION_LEVEL", 0);
        StringBuffer optim = new StringBuffer();
        switch (optimLevel) {
            case 1: {
                optim.append("-O1");
                break;
            }
            case 2: {
                optim.append("-O2");
                break;
            }
            case 3: {
                optim.append("-O3");
                break;
            }
            case 4: {
                optim.append("-Os");
                break;
            }
            default: {
                optim.append("-O0");
            }
        }
        return optim.toString();
    }

    protected abstract String getCompilerExecutable();

    protected abstract StringBuffer getCompilerCommand(ILaunchConfiguration var1) throws CoreException;

    protected abstract Process startProcessOnTarget(ILaunch var1, ILaunchConfiguration var2, StringBuffer var3, String var4, PrintStream var5, IProgressMonitor var6) throws CoreException;
}

