/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.debugging.variables;

import icecaptools.debugging.variables.HVMBooleanVariable;
import icecaptools.debugging.variables.HVMByteVariable;
import icecaptools.debugging.variables.HVMCharVariable;
import icecaptools.debugging.variables.HVMDoubleVariable;
import icecaptools.debugging.variables.HVMFloatVariable;
import icecaptools.debugging.variables.HVMIntVariable;
import icecaptools.debugging.variables.HVMLongVariable;
import icecaptools.debugging.variables.HVMReferenceVariable;
import icecaptools.debugging.variables.HVMShortVariable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;

public class HVMVariableFactory {
    public static IVariable getHVMVariable(IDebugTarget debugTarget, LocalVariable localVariable, Method method) {
        String sig = Utility.signatureToString((String)localVariable.getSignature());
        if ("byte".equals(sig)) {
            return new HVMByteVariable(debugTarget, localVariable, method);
        }
        if ("char".equals(sig)) {
            return new HVMCharVariable(debugTarget, localVariable, method);
        }
        if ("double".equals(sig)) {
            return new HVMDoubleVariable(debugTarget, localVariable, method);
        }
        if ("float".equals(sig)) {
            return new HVMFloatVariable(debugTarget, localVariable, method);
        }
        if ("int".equals(sig)) {
            return new HVMIntVariable(debugTarget, localVariable, method);
        }
        if ("long".equals(sig)) {
            return new HVMLongVariable(debugTarget, localVariable, method);
        }
        if ("short".equals(sig)) {
            return new HVMShortVariable(debugTarget, localVariable, method);
        }
        if ("boolean".equals(sig)) {
            return new HVMBooleanVariable(debugTarget, localVariable, method);
        }
        return new HVMReferenceVariable(debugTarget, localVariable, method);
    }
}

