/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.debugging;

import icecaptools.debugging.DebugChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IProgressMonitor;

public class TCPChannel
extends DebugChannel {
    private int requestResponseChannel;
    private int eventChannel;
    private String targetIPAddress;
    private Socket requestResponseSocket;
    private Socket eventSocket;

    public TCPChannel(int requestResponseChannel, int eventChannel, String targetIPAddress) {
        this.requestResponseChannel = requestResponseChannel;
        this.eventChannel = eventChannel;
        this.targetIPAddress = targetIPAddress;
    }

    @Override
    public void connectToTarget(IProgressMonitor monitor) throws UnknownHostException, IOException {
        monitor.subTask("Connect debug request port");
        this.requestResponseSocket = TCPChannel.connectToPort(this.targetIPAddress, this.requestResponseChannel, monitor);
        monitor.subTask("Connect debug response port");
        this.eventSocket = TCPChannel.connectToPort(this.targetIPAddress, this.eventChannel, monitor);
    }

    private static Socket connectToPort(String host, int port, IProgressMonitor monitor) throws UnknownHostException, IOException {
        int i = 0;
        while (true) {
            try {
                Socket socket = new Socket(host, port);
                return socket;
            }
            catch (IOException e) {
                if (++i > 10) {
                    throw e;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                monitor.worked(1);
                continue;
            }
            break;
        }
    }

    @Override
    public InputStream getEventChannel() throws IOException {
        return this.eventSocket.getInputStream();
    }

    @Override
    public OutputStream getRequestOutputStream() throws IOException {
        return this.requestResponseSocket.getOutputStream();
    }

    @Override
    public InputStream getRequestInputStream() throws IOException {
        return this.requestResponseSocket.getInputStream();
    }

    @Override
    public void disconnectFromTarget() throws IOException {
        this.requestResponseSocket.close();
    }
}

