/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.debugging;

import icecaptools.debugging.HVMDebugElement;
import icecaptools.debugging.HVMPOSIXDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class HVMThread
extends HVMDebugElement
implements IThread {
    private IStackFrame[] stackFrames = null;
    private static final int STEPRETURN = 2;

    protected HVMThread(IDebugTarget target) {
        super(target);
    }

    public boolean canResume() {
        return ((HVMPOSIXDebugTarget)this.target).canResume();
    }

    public boolean canSuspend() {
        return ((HVMPOSIXDebugTarget)this.target).canSuspend();
    }

    public boolean isSuspended() {
        return ((HVMPOSIXDebugTarget)this.target).isSuspended();
    }

    public void resume() throws DebugException {
        ((HVMPOSIXDebugTarget)this.target).resume();
    }

    public void suspend() throws DebugException {
        ((HVMPOSIXDebugTarget)this.target).suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return ((HVMPOSIXDebugTarget)this.target).isStepping();
    }

    public void stepInto() throws DebugException {
        ((HVMPOSIXDebugTarget)this.target).stepInto();
    }

    public void stepOver() throws DebugException {
        ((HVMPOSIXDebugTarget)this.target).stepOver();
    }

    public void stepReturn() throws DebugException {
        System.out.println("HVMThread: stepReturn");
    }

    public boolean canTerminate() {
        return ((HVMPOSIXDebugTarget)this.target).canTerminate();
    }

    public boolean isTerminated() {
        return ((HVMPOSIXDebugTarget)this.target).isTerminated();
    }

    public void terminate() throws DebugException {
        ((HVMPOSIXDebugTarget)this.target).terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStackFrame[] getStackFrames() throws DebugException {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        synchronized (iDebugTarget) {
            if (this.stackFrames == null) {
                if (this.isSuspended()) {
                    this.stackFrames = ((HVMPOSIXDebugTarget)this.target).getStackFrames();
                    return this.stackFrames;
                }
            } else if (this.isSuspended()) {
                return this.stackFrames;
            }
        }
        return new IStackFrame[0];
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        System.out.println("HVMThread: getPriority");
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (this.stackFrames != null && this.stackFrames.length > 0) {
            return this.stackFrames[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        return ((HVMPOSIXDebugTarget)this.target).getName();
    }

    public IBreakpoint[] getBreakpoints() {
        IBreakpoint activeBreakPoint = ((HVMPOSIXDebugTarget)this.target).getActiveBreakPoint();
        if (activeBreakPoint != null) {
            return new IBreakpoint[]{activeBreakPoint};
        }
        return null;
    }

    public void clearStackFrames() {
        if (this.stackFrames != null) {
            this.stackFrames = null;
        }
    }
}

