/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.debugging;

import icecaptools.BNode;
import icecaptools.ClassfileUtils;
import icecaptools.CompilationSequence;
import icecaptools.ConverterJob;
import icecaptools.MethodAndClass;
import icecaptools.MethodEntryPoints;
import icecaptools.MethodOrFieldDesc;
import icecaptools.compiler.ByteCodePatcher;
import icecaptools.debugging.HVMDebugElement;
import icecaptools.debugging.HVMThread;
import icecaptools.debugging.variables.HVMVariableFactory;
import java.util.ArrayList;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class HVMStackFrame
extends HVMDebugElement
implements IStackFrame {
    private int methodNumber;
    private int pc;
    private HVMThread thread;
    private int originalAddress;
    private IVariable[] variables;
    private MethodAndClass methodAndClass;

    public HVMStackFrame(HVMThread thread, int methodNumber, int pc) throws DebugException {
        super(thread.getDebugTarget());
        this.methodNumber = methodNumber;
        this.pc = pc;
        this.thread = thread;
        this.setupVariables();
    }

    private void setupVariables() throws DebugException {
        ByteCodePatcher patcher;
        MethodOrFieldDesc method;
        CompilationSequence compilationSequence = ConverterJob.mostRecentSequence;
        if (compilationSequence != null && (method = (patcher = compilationSequence.getPatcher()).getMethodDescriptor(this.methodNumber)) != null) {
            MethodEntryPoints ep = compilationSequence.getDependencyExtent().getMethod(method.getClassName(), method.getName(), method.getSignature());
            BNode bnode = ep.getBNodeFromHVMAddress(this.pc);
            this.originalAddress = bnode.getOriginalAddress();
            try {
                this.methodAndClass = ClassfileUtils.findMethod(method.getClassName(), method.getName(), method.getSignature());
                LocalVariableTable lvTable = this.methodAndClass.getMethod().getLocalVariableTable();
                LocalVariable[] table = lvTable.getLocalVariableTable();
                ArrayList<IVariable> variables = new ArrayList<IVariable>();
                int i = 0;
                while (i < table.length) {
                    LocalVariable lv = table[i];
                    if (lv.getStartPC() <= this.originalAddress && this.originalAddress < lv.getStartPC() + lv.getLength()) {
                        variables.add(HVMVariableFactory.getHVMVariable(this.getDebugTarget(), lv, this.methodAndClass.getMethod()));
                    }
                    ++i;
                }
                this.variables = new IVariable[variables.size()];
                i = 0;
                while (i < variables.size()) {
                    this.variables[i] = (IVariable)variables.get(i);
                    ++i;
                }
                return;
            }
            catch (Exception exception) {
                this.variables = new IVariable[0];
                throw new DebugException(new IStatus(){
                    private static final String message = "Could not get method information";

                    public IStatus[] getChildren() {
                        return null;
                    }

                    public int getCode() {
                        return 4;
                    }

                    public Throwable getException() {
                        return new Exception(message);
                    }

                    public String getMessage() {
                        return message;
                    }

                    public String getPlugin() {
                        return DebugPlugin.getUniqueIdentifier();
                    }

                    public int getSeverity() {
                        return 4;
                    }

                    public boolean isMultiStatus() {
                        return false;
                    }

                    public boolean isOK() {
                        return false;
                    }

                    public boolean matches(int severityMask) {
                        return false;
                    }
                });
            }
        }
        this.variables = new IVariable[0];
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().isTerminated();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        return this.variables.length > 0;
    }

    public int getLineNumber() throws DebugException {
        if (this.methodAndClass != null) {
            int lineNumber = ClassfileUtils.getLineNumber(this.methodAndClass.getMethod(), this.originalAddress);
            return lineNumber;
        }
        return 0;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        CompilationSequence compilationSequence = ConverterJob.mostRecentSequence;
        if (compilationSequence != null) {
            StringBuffer buffer = new StringBuffer();
            ByteCodePatcher patcher = compilationSequence.getPatcher();
            MethodOrFieldDesc desc = patcher.getMethodDescriptor(this.methodNumber);
            buffer.append(desc.getClassName());
            buffer.append(".");
            buffer.append(desc.getName());
            buffer.append("(");
            buffer.append(desc.getSignature());
            buffer.append(") pc: ");
            buffer.append(this.pc);
            return buffer.toString();
        }
        return "unknown";
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public int getMethodNumber() {
        return this.methodNumber;
    }

    public void clear() {
    }
}

