/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.aot;

import icecaptools.BNode;
import icecaptools.IcecapCVar;
import icecaptools.NativeFieldInfo;
import icecaptools.compiler.FieldInfo;
import icecaptools.compiler.NoDuplicatesMemorySegment;
import icecaptools.compiler.aot.AOTToolBox;
import icecaptools.compiler.aot.FieldAccessEmitter;
import icecaptools.compiler.aot.StackManager;
import icecaptools.stackanalyser.ProducerConsumerStack;

public abstract class StaticFieldEmitter {
    private int pc;
    private AOTToolBox toolBox;
    private byte[] currentMethodCode;
    private NoDuplicatesMemorySegment localVariables;
    private StringBuffer output;
    private StackManager sm;
    private NoDuplicatesMemorySegment requiredIncludes;
    private BNode bnode;

    public StaticFieldEmitter(int pc, AOTToolBox toolBox, byte[] currentMethodCode, NoDuplicatesMemorySegment localVariables, StringBuffer output, StackManager sm, NoDuplicatesMemorySegment requiredIncludes, BNode bnode) {
        this.pc = pc;
        this.toolBox = toolBox;
        this.currentMethodCode = currentMethodCode;
        this.localVariables = localVariables;
        this.output = output;
        this.sm = sm;
        this.requiredIncludes = requiredIncludes;
        this.bnode = bnode;
    }

    public FieldAccessEmitter getEmitter() {
        if (this.currentMethodCode[this.pc] == -77) {
            return new PutStaticFieldEmitter();
        }
        return new GetStaticFieldEmitter();
    }

    protected void handleNativeField(StringBuffer output, NativeFieldInfo nInfo, String type) {
        IcecapCVar cvar = nInfo.getCVar();
        String expression = cvar.expression();
        String includes = cvar.requiredIncludes();
        if (expression == null) {
            output.append("      sdata = (unsigned char*) &" + nInfo.getField().getName() + ";\n");
        } else {
            output.append("      sdata = (unsigned char*) &" + expression + ";\n");
        }
        if (includes == null) {
            this.requiredIncludes.print("extern " + type + " " + nInfo.getField().getName() + ";\n");
        } else {
            this.a_addUserIncludes(this.requiredIncludes, includes);
        }
    }

    protected abstract void a_addUserIncludes(NoDuplicatesMemorySegment var1, String var2);

    protected abstract int a_normalizeConsumerSize(BNode var1, int var2) throws Exception;

    private abstract class GeneralFieldAccessEmitter
    implements FieldAccessEmitter {
        protected int foffset;
        protected short fsize;
        protected int classIndex;
        protected FieldInfo fInfo;
        protected NativeFieldInfo nInfo;
        protected String type;

        private GeneralFieldAccessEmitter() {
        }

        protected void setup() {
            FieldInfo[] fieldOffsets = StaticFieldEmitter.this.toolBox.getPatcher().getFieldOffsets();
            this.fInfo = fieldOffsets[StaticFieldEmitter.this.pc + 4];
            this.classIndex = StaticFieldEmitter.this.currentMethodCode[StaticFieldEmitter.this.pc + 1] << 8 & 0xFFFF;
            this.classIndex |= StaticFieldEmitter.this.currentMethodCode[StaticFieldEmitter.this.pc + 2] & 0xFF;
            this.fsize = (short)(StaticFieldEmitter.this.currentMethodCode[StaticFieldEmitter.this.pc + 3] & 0xFF);
            short byte1 = (short)(StaticFieldEmitter.this.currentMethodCode[StaticFieldEmitter.this.pc + 4] & 0xFF);
            short byte2 = (short)(StaticFieldEmitter.this.currentMethodCode[StaticFieldEmitter.this.pc + 5] & 0xFF);
            this.foffset = byte1 << 8 | byte2;
            String containingClass = StaticFieldEmitter.this.toolBox.getPatcher().getClassName(this.classIndex);
            this.nInfo = StaticFieldEmitter.this.toolBox.getObserver().isNativeField(containingClass, this.fInfo);
            switch (this.fsize & 0xFC) {
                case 16: {
                    this.type = "int16";
                    break;
                }
                case 8: {
                    this.type = "int8";
                    break;
                }
                default: {
                    this.type = "int32";
                }
            }
        }
    }

    private class GetStaticFieldEmitter
    extends GeneralFieldAccessEmitter {
        private GetStaticFieldEmitter() {
        }

        @Override
        public void performFieldAccess() throws Exception {
            this.setup();
            ProducerConsumerStack exitStack = ((StaticFieldEmitter)StaticFieldEmitter.this).bnode.getAinfo().exitStack;
            int dstSize = StaticFieldEmitter.this.a_normalizeConsumerSize(StaticFieldEmitter.this.bnode, exitStack.size() - 1);
            if (dstSize == 0) {
                dstSize = 3;
            }
            if (this.nInfo != null) {
                this.getStaticNativeField();
            } else {
                if (this.fInfo == null || this.fInfo.isFloat) {
                    StaticFieldEmitter.this.localVariables.print("   unsigned char* sdata;\n");
                    StaticFieldEmitter.this.output.append("      sdata = classData + " + (this.foffset >> 3) + ";\n");
                }
                StaticFieldEmitter.this.requiredIncludes.print("extern const unsigned char *classData;\n");
                if (this.fInfo != null && !this.fInfo.isFloat) {
                    StringBuffer buffer = new StringBuffer();
                    if ((this.fsize & 0xFC) > 32) {
                        buffer.append("((struct ");
                        buffer.append(this.fInfo.getStructName());
                        buffer.append(" *)classData) -> ");
                        buffer.append(this.fInfo.getStructMemberLSBName());
                        StaticFieldEmitter.this.sm.push(3, buffer.toString());
                        buffer = new StringBuffer();
                    }
                    buffer.append("((struct ");
                    buffer.append(this.fInfo.getStructName());
                    buffer.append(" *)classData) -> ");
                    buffer.append(this.fInfo.getStructMemberName());
                    StaticFieldEmitter.this.sm.push(dstSize, buffer.toString());
                } else {
                    switch (this.fsize & 0xFC) {
                        case 64: {
                            StaticFieldEmitter.this.sm.push(3, "*(int32*) &sdata[4]");
                        }
                        case 32: {
                            StaticFieldEmitter.this.sm.push(dstSize, "*(int32*) sdata");
                            break;
                        }
                        case 16: {
                            StaticFieldEmitter.this.sm.push(dstSize, "*(signed short*) sdata");
                            break;
                        }
                        case 8: {
                            StaticFieldEmitter.this.sm.push(dstSize, "*(signed char*) sdata");
                        }
                    }
                }
            }
            StaticFieldEmitter.this.requiredIncludes.print("extern const ClassInfo *classes;\n");
        }

        private void getStaticNativeField() {
            IcecapCVar cvar = this.nInfo.getCVar();
            String expression = cvar.expression();
            String includes = cvar.requiredIncludes();
            if (includes == null) {
                StaticFieldEmitter.this.requiredIncludes.print("extern " + this.type + " " + this.nInfo.getField().getName() + ";\n");
            } else {
                StaticFieldEmitter.this.a_addUserIncludes(StaticFieldEmitter.this.requiredIncludes, includes);
            }
            String fieldName = expression == null ? this.nInfo.getField().getName() : expression;
            switch (this.fsize & 0xFC) {
                case 64: {
                    StaticFieldEmitter.this.localVariables.print("   unsigned char* sdata;\n");
                    if (expression == null) {
                        StaticFieldEmitter.this.output.append("      sdata = (unsigned char*) &" + this.nInfo.getField().getName() + ";\n");
                    } else {
                        StaticFieldEmitter.this.output.append("      sdata = (unsigned char*) &" + expression + ";\n");
                    }
                    StaticFieldEmitter.this.sm.push(3, "*(int32*) &sdata[4]");
                    StaticFieldEmitter.this.sm.push(3, "*(int32*) sdata");
                    break;
                }
                case 32: {
                    StaticFieldEmitter.this.sm.push(3, "(int32)" + fieldName);
                    break;
                }
                case 16: {
                    StaticFieldEmitter.this.sm.push(2, fieldName);
                    break;
                }
                case 8: {
                    StaticFieldEmitter.this.sm.push(1, fieldName);
                }
            }
        }
    }

    private class PutStaticFieldEmitter
    extends GeneralFieldAccessEmitter {
        private PutStaticFieldEmitter() {
        }

        @Override
        public void performFieldAccess() throws Exception {
            int srcSize;
            this.setup();
            switch (this.fsize & 0xFC) {
                case 16: {
                    srcSize = 2;
                    break;
                }
                case 8: {
                    srcSize = 1;
                    break;
                }
                default: {
                    srcSize = 3;
                }
            }
            if (this.fsize >> 3 > 4) {
                StaticFieldEmitter.this.localVariables.print("   int32 msb_int32;\n");
            }
            StaticFieldEmitter.this.localVariables.print("   " + this.type + " lsb_" + this.type + ";\n");
            StaticFieldEmitter.this.sm.pop("      lsb_" + this.type, srcSize);
            if (this.nInfo != null) {
                this.putStaticNativeField();
            } else {
                if (this.fInfo == null || this.fInfo.isFloat) {
                    StaticFieldEmitter.this.localVariables.print("   unsigned char* sdata;\n");
                    StaticFieldEmitter.this.output.append("      sdata = classData + " + (this.foffset >> 3) + ";\n");
                }
                StaticFieldEmitter.this.requiredIncludes.print("extern const unsigned char *classData;\n");
                if (this.fsize >> 3 > 4) {
                    StaticFieldEmitter.this.sm.pop("      msb_int32", 3);
                }
                if (this.fInfo != null && !this.fInfo.isFloat) {
                    StaticFieldEmitter.this.output.append("      ((struct ");
                    StaticFieldEmitter.this.output.append(this.fInfo.getStructName());
                    StaticFieldEmitter.this.output.append(" *)classData) -> ");
                    StaticFieldEmitter.this.output.append(this.fInfo.getStructMemberName());
                    StaticFieldEmitter.this.output.append(" = lsb_" + this.type + ";\n");
                    if ((this.fsize & 0xFC) > 32) {
                        StaticFieldEmitter.this.output.append("      ((struct ");
                        StaticFieldEmitter.this.output.append(this.fInfo.getStructName());
                        StaticFieldEmitter.this.output.append(" *)classData) -> ");
                        StaticFieldEmitter.this.output.append(this.fInfo.getStructMemberLSBName());
                        StaticFieldEmitter.this.output.append(" = msb_int32;\n");
                    }
                } else {
                    switch (this.fsize & 0xFC) {
                        case 64: {
                            StaticFieldEmitter.this.output.append("      *(int32*) &sdata[4] = msb_int32;\n");
                        }
                        case 32: {
                            StaticFieldEmitter.this.output.append("      *((int32*) sdata) = lsb_" + this.type + ";\n");
                            break;
                        }
                        case 16: {
                            StaticFieldEmitter.this.output.append("      *((signed short*) sdata) = lsb_" + this.type + ";\n");
                            break;
                        }
                        case 8: {
                            StaticFieldEmitter.this.output.append("      *((signed char*) sdata) = lsb_" + this.type + ";\n");
                        }
                    }
                }
            }
            StaticFieldEmitter.this.requiredIncludes.print("extern const ClassInfo *classes;\n");
        }

        private void putStaticNativeField() {
            IcecapCVar cvar = this.nInfo.getCVar();
            String expression = cvar.expression();
            String includes = cvar.requiredIncludes();
            if (includes == null) {
                StaticFieldEmitter.this.requiredIncludes.print("extern " + this.type + " " + this.nInfo.getField().getName() + ";\n");
            } else {
                StaticFieldEmitter.this.a_addUserIncludes(StaticFieldEmitter.this.requiredIncludes, includes);
            }
            if (this.fsize >> 3 > 4) {
                StaticFieldEmitter.this.sm.pop("      msb_int32", 3);
            }
            String fieldName = expression == null ? this.nInfo.getField().getName() : expression;
            switch (this.fsize & 0xFC) {
                case 64: {
                    StaticFieldEmitter.this.localVariables.print("   unsigned char* sdata;\n");
                    if (expression == null) {
                        StaticFieldEmitter.this.output.append("      sdata = (unsigned char*) &" + this.nInfo.getField().getName() + ";\n");
                    } else {
                        StaticFieldEmitter.this.output.append("      sdata = (unsigned char*) &" + expression + ";\n");
                    }
                    StaticFieldEmitter.this.output.append("      *(int32*) &sdata[4] = msb_int32;\n");
                    StaticFieldEmitter.this.output.append("      *((int32*) sdata) = lsb_" + this.type + ";\n");
                    break;
                }
                case 32: {
                    StaticFieldEmitter.this.output.append("      " + fieldName + " = lsb_" + this.type + ";\n");
                    break;
                }
                case 16: {
                    StaticFieldEmitter.this.output.append("      " + fieldName + " = lsb_" + this.type + ";\n");
                    break;
                }
                case 8: {
                    StaticFieldEmitter.this.output.append("      " + fieldName + " = lsb_" + this.type + ";\n");
                }
            }
        }
    }
}

