/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.aot;

import icecaptools.compiler.NoDuplicatesMemorySegment;
import icecaptools.compiler.aot.AOTCompiler;
import icecaptools.compiler.aot.LocalVariableManager;
import icecaptools.compiler.aot.PreloadingVariableManager;
import icecaptools.compiler.aot.SPManipulator;
import icecaptools.compiler.aot.TypeAwareVariableManager;

public class StackManager {
    protected StringBuffer output;
    protected NoDuplicatesMemorySegment localVariables;
    protected LocalVariableManager localVariableManager;
    protected boolean isSynthetic;
    protected SPManipulator spManipulator;

    public StackManager(StringBuffer output, NoDuplicatesMemorySegment localVariables, int maxLocals, boolean isSynthetic, SPManipulator spManipulator) {
        this.output = output;
        this.localVariables = localVariables;
        this.spManipulator = spManipulator;
        this.localVariableManager = isSynthetic ? new PreloadingVariableManager(maxLocals, output, localVariables) : new TypeAwareVariableManager(maxLocals, output, localVariables);
        this.isSynthetic = isSynthetic;
    }

    public void push(String value) {
        this.push(3, value);
    }

    public void pop(String dst, int srcSize) {
        this.popIt(dst, srcSize);
    }

    private void popIt(String dst, int srcSize) {
        String srctype = AOTCompiler.getTypeCast(srcSize);
        srctype = srcSize == 4 ? AOTCompiler.getPointerCast(srcSize) : AOTCompiler.getTypeCast(srcSize);
        this.output.append("   sp--;\n");
        this.spManipulator.setSPUsed(true);
        if (dst != null) {
            if (srcSize == 4) {
                this.output.append(String.valueOf(dst) + " = *" + srctype + "sp;\n");
            } else {
                this.output.append(String.valueOf(dst) + " = (" + srctype + ")(*sp);\n");
            }
        }
    }

    public void popRef(String dst) {
        this.spManipulator.setSPUsed(true);
        this.output.append("   sp--;\n");
        this.output.append(String.valueOf(dst) + " = (unsigned char *) (pointer) *sp;\n");
    }

    public String peekTop(int index, int srcSize) {
        String srctype = "";
        if (srcSize != 3) {
            srctype = AOTCompiler.getPointerCast(srcSize);
        }
        String topValue = index > 0 ? "*" + srctype + "(sp - " + index + ")" : "*" + srctype + "sp";
        this.spManipulator.setSPUsed(true);
        return topValue;
    }

    public void push(int dstSize, String value) {
        this.pushIt(dstSize, value);
    }

    protected void pushIt(int dstSize, String value) {
        String dsttype = "";
        if (dstSize != 3) {
            dsttype = dstSize == 4 ? AOTCompiler.getPointerCast(dstSize) : AOTCompiler.getTypeCast(dstSize);
        }
        if (dstSize == 4) {
            this.output.append("   *(" + dsttype + "sp) = " + value + ";\n");
        } else if (dsttype.length() > 0) {
            this.output.append("   *sp = (int32)(" + dsttype + ")" + value + ";\n");
        } else {
            this.output.append("   *sp = (int32)" + value + ";\n");
        }
        this.output.append("   sp++;\n");
        this.spManipulator.setSPUsed(true);
    }

    public int flush(boolean doit) {
        return 0;
    }

    public void setOutput(StringBuffer output) {
        this.output = output;
    }

    public StackManager copy() {
        StackManager clone = new StackManager(this.output, this.localVariables, this.localVariableManager.getMaxLocals(), this.isSynthetic, this.spManipulator);
        clone.localVariableManager.copyLocals(this.localVariableManager);
        return clone;
    }

    public boolean equals(Object other) {
        if (other.getClass() == StackManager.class) {
            return this.localVariableManager.equals(((StackManager)other).localVariableManager);
        }
        return false;
    }

    public void merge(StackManager other) throws Exception {
        this.localVariableManager.merge(other.localVariableManager, 0, this.output, this.localVariables);
    }

    public void load(int size, int index, int pc) {
        this.localVariableManager.load(size, index, pc, this.output, this.localVariables);
    }

    public String getLocal(int index, int pc) throws Exception {
        return this.localVariableManager.getLocal(index, pc);
    }

    public void setLocal(int size, int index, int pc) throws Exception {
        this.localVariableManager.setLocal(size, index, pc, this.localVariables);
    }

    public void flushLocals() {
        this.localVariableManager.flush(this.output, false);
    }

    public StringBuffer getOutput() {
        return this.output;
    }

    public void flushTop(boolean doit) {
    }

    public LocalVariableManager getLocalVariableManager() {
        return this.localVariableManager;
    }

    public boolean isCached(int i) {
        return false;
    }

    public int topSize() {
        return 3;
    }
}

