/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.aot;

import icecaptools.compiler.NoDuplicatesMemorySegment;
import icecaptools.compiler.aot.AOTCompiler;
import icecaptools.compiler.aot.SPManipulator;
import icecaptools.compiler.aot.StackCellInfo;
import icecaptools.compiler.aot.StackManager;

public class Level1RegisterAllocator
extends StackManager {
    protected StackCellInfo top = null;

    public Level1RegisterAllocator(StringBuffer output, NoDuplicatesMemorySegment localVariables, int maxLocals, SPManipulator spManipulator) {
        super(output, localVariables, maxLocals, false, spManipulator);
    }

    @Override
    public void pop(String dst, int srcSize) {
        if (this.top == null) {
            super.pop(dst, srcSize);
        } else {
            this.output.append(String.valueOf(dst) + " = " + this.top.v_name + ";\n");
            this.top = null;
        }
    }

    @Override
    public void popRef(String dst) {
        if (this.top == null) {
            super.popRef(dst);
        } else {
            this.output.append(String.valueOf(dst) + " = (unsigned char *) (pointer)" + this.top.v_name + ";\n");
            this.top = null;
        }
    }

    @Override
    public String peekTop(int index, int srcSize) {
        if (this.top == null) {
            return super.peekTop(index, srcSize);
        }
        if (index == 1) {
            return this.top.v_name;
        }
        return super.peekTop(index - 1, srcSize);
    }

    @Override
    public void push(int dstSize, String value) {
        if (this.top == null) {
            this.top = new StackCellInfo();
            this.top.size = dstSize;
            switch (this.top.size) {
                case 1: {
                    this.top.v_name = "b_val";
                    break;
                }
                case 2: {
                    this.top.v_name = "s_val";
                    break;
                }
                default: {
                    this.top.v_name = "i_val";
                }
            }
            this.output.append("   " + this.top.v_name + " = " + value + ";\n");
            this.localVariables.print("   " + AOTCompiler.getTypeCast(dstSize) + " " + this.top.v_name + ";\n");
        } else {
            this.flush(true);
            this.push(dstSize, value);
        }
    }

    @Override
    public int flush(boolean doit) {
        if (this.top != null) {
            super.push(this.top.size, this.top.v_name);
            if (doit) {
                this.top = null;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int topSize() {
        if (this.top != null) {
            return this.top.size;
        }
        return 3;
    }
}

