/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.MethodOrFieldDesc;
import icecaptools.compiler.IDGenerator;
import icecaptools.compiler.RequiredEntryManager;
import java.util.ArrayList;

public class RequiredMethodsManager
extends RequiredEntryManager {
    private ArrayList<String> entries = new ArrayList();

    public RequiredMethodsManager(IDGenerator idGen, boolean supportLoading) {
        super(supportLoading);
        this.addRequiredMethod(idGen, "java.lang.String", "<init>", "([C)V", "java_lang_String_initFromCharArray");
        this.addRequiredMethod(idGen, "java.lang.ClassCastException", "<init>", "()V", "java_lang_ClassCastException_init_");
        this.addRequiredMethod(idGen, "java.lang.ArithmeticException", "<init>", "()V", "java_lang_ArithmeticException_init_");
        this.addRequiredMethod(idGen, "java.lang.OutOfMemoryError", "<init>", "()V", "java_lang_OutOfMemoryError_init_");
        this.addRequiredMethod(idGen, "java.lang.NullPointerException", "<init>", "()V", "java_lang_NullPointerException_init_");
        this.addRequiredMethod(idGen, "java.lang.Object", "clone", "()Ljava/lang/Object;", null);
        this.addRequiredMethod(idGen, "vm.InterruptDispatcher", "interrupt", "(B)V", null);
        this.addRequiredMethod(idGen, "tasks.ModbusDispatcher", "dispatch", "(BB)Z", null);
        this.addRequiredMethod(idGen, "java.lang.StringBuffer", "append", "(F)Ljava/lang/StringBuffer;", "java_lang_StringBuffer_append");
        this.addRequiredMethod(idGen, "java.lang.StringBuilder", "append", "(F)Ljava/lang/StringBuilder;", "java_lang_StringBuilder_append");
        this.addRequiredMethod(idGen, "java.lang.String", "<init>", "([BII)V", "java_lang_String_init_");
        this.addRequiredMethod(idGen, "java.lang.Float", "toString", "()Ljava/lang/String;", "java_lang_Float_toString");
        this.addRequiredMethod(idGen, "java.lang.Thread", "<init>", "()V", "java_lang_Thread_init_default");
    }

    private void addRequiredMethod(IDGenerator idGen, String clazz, String name, String sig, String preferred) {
        if (preferred != null) {
            this.requiredEntries.add(idGen.getUniqueId(clazz, name, sig, preferred));
        } else {
            this.requiredEntries.add(idGen.getUniqueId(clazz, name, sig));
        }
        this.entries.add(String.valueOf(clazz) + name + sig);
    }

    public boolean isRequieredMethod(MethodOrFieldDesc mdesc) {
        return this.entries.contains(String.valueOf(mdesc.getClassName()) + mdesc.getName() + mdesc.getSignature());
    }
}

