/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.compiler.MemorySegment;

public class MethodsFile {
    private MemorySegment header;
    private StringBuffer implementation;
    private boolean supportLoader;

    public MethodsFile(boolean supportLoader) {
        this.supportLoader = supportLoader;
    }

    public void setHeader(MemorySegment header) {
        this.header = header;
    }

    public void generateNumberOfClassInitializersDecl() {
        if (this.supportLoader) {
            this.header.print("extern uint16 NUMBEROFCLASSINITIALIZERS_var;\n");
        } else {
            this.header.print("#define NUMBEROFCLASSINITIALIZERS_var NUMBEROFCLASSINITIALIZERS\n");
        }
    }

    public void setImplementation(StringBuffer result) {
        this.implementation = result;
    }

    public void generateNumberOfClassInitializersImpl() {
        if (this.supportLoader) {
            this.implementation.append("uint16 NUMBEROFCLASSINITIALIZERS_var = NUMBEROFCLASSINITIALIZERS;\n");
        }
    }

    public void generateNumberOfConstantsDecl() {
        if (this.supportLoader) {
            this.header.print("extern uint16 NUMBEROFCONSTANTS_var;\n");
        } else {
            this.header.print("#define NUMBEROFCONSTANTS_var NUMBEROFCONSTANTS\n");
        }
    }

    public void generateNumberOfConstantsImpl() {
        if (this.supportLoader) {
            this.implementation.append("uint16 NUMBEROFCONSTANTS_var = NUMBEROFCONSTANTS;\n");
        }
    }

    public void generateMainMethodIndexDecl() {
        if (this.supportLoader) {
            this.header.print("extern uint16 mainMethodIndex;\n");
        } else {
            this.header.print("#define mainMethodIndex MAINMETHODINDEX\n");
        }
    }

    public void generateMainMethodIndexImpl() {
        if (this.supportLoader) {
            this.implementation.append("uint16 mainMethodIndex = MAINMETHODINDEX;\n");
        }
    }
}

