/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.compiler.utils.CompareableStringBuffer;
import java.util.HashMap;
import java.util.HashSet;

public class IDGenerator {
    private HashSet<String> ids = new HashSet();
    private HashMap<String, String> generatedNames = new HashMap();

    public String getUniqueId(String className, String methodName, String signature) {
        return this.getUniqueId(className, methodName, signature, null);
    }

    public String getUniqueId(String className, String methodName, String signature, String preferredName) {
        StringBuffer key = new StringBuffer();
        key.append(className);
        key.append(methodName);
        key.append(signature);
        String result = this.generatedNames.get(key.toString());
        if (result == null) {
            if (preferredName == null) {
                CompareableStringBuffer name = new CompareableStringBuffer();
                int length = className.length();
                int i = 0;
                while (i < length) {
                    char next = className.charAt(i);
                    if (next >= 'a' && next <= 'z') {
                        name.append(next);
                    } else if (next >= 'A' && next <= 'Z') {
                        name.append(next);
                    } else if (next >= '0' && next <= '9') {
                        name.append(next);
                    } else {
                        name.append('_');
                    }
                    ++i;
                }
                if (methodName.charAt(0) == '<') {
                    methodName = methodName.replace("<", "_").replace(">", "_");
                } else {
                    name.append('_');
                }
                methodName = methodName.replace("$", "_");
                name.append(methodName);
                while (this.ids.contains(name.toString())) {
                    name.append('_');
                }
                result = name.toString();
            } else {
                result = preferredName;
            }
            this.ids.add(result);
            this.generatedNames.put(key.toString(), result);
        }
        return result;
    }
}

