/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

public class FieldInfo {
    private String name;
    private int offset;
    private int size;
    public boolean isVolatile;
    public boolean isReference;
    public boolean isFloat;
    private String structMemberName;
    private String structName;
    private String structMemberLSBName;
    public boolean isClassField;
    private boolean isHWObjectField;

    public FieldInfo(String name, int offset, int size, boolean isVolatile, boolean isReference, boolean isFloat, boolean isClassField, boolean isHWObjectField) {
        this.name = name;
        this.offset = offset;
        this.size = size;
        this.isVolatile = isVolatile;
        this.isReference = isReference;
        this.isFloat = isFloat;
        this.isClassField = isClassField;
        this.isHWObjectField = isHWObjectField;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        int result = this.size;
        if (this.isVolatile) {
            result |= 1;
        }
        if (this.isReference) {
            result |= 2;
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setStructMemberName(String memberName) {
        this.structMemberName = memberName;
    }

    public void setStructName(String structName) {
        this.structName = structName;
    }

    public String getStructName() {
        return this.structName;
    }

    public String getStructMemberName() {
        return this.structMemberName;
    }

    public void setStructMemberLSBName(String structMemberLSBName) {
        this.structMemberLSBName = structMemberLSBName;
    }

    public Object getStructMemberLSBName() {
        return this.structMemberLSBName;
    }

    public boolean isHwObjectAddressField() {
        return this.name.equals("address") && this.isHWObjectField;
    }
}

