/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public class CustomClassLoader {
    private final boolean debug = true;
    private String path;
    private HashSet<JavaClass> classSet;

    public CustomClassLoader(String path) {
        this.path = path;
        this.classSet = new HashSet();
    }

    public void loadJar() {
        try {
            ZipEntry currentEntry;
            FileInputStream inputStream = new FileInputStream(this.path);
            JarInputStream jarInputStream = new JarInputStream((InputStream)inputStream, true);
            while ((currentEntry = jarInputStream.getNextEntry()) != null) {
                if (currentEntry.isDirectory()) continue;
                ClassParser classParser = new ClassParser((InputStream)jarInputStream, currentEntry.getName());
                JavaClass clazz = classParser.parse();
                this.classSet.add(clazz);
                System.out.println("Parsed class: " + clazz.getClassName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JavaClass[] getAllClasses() {
        return this.classSet.toArray(new JavaClass[0]);
    }
}

