/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import extensions.ArchitectureDependentCodeGenerator;
import icecaptools.compiler.CodeDetector;
import icecaptools.extensions.ExtensionManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ArchitectureDependentCodeDetector
extends ExtensionManager<ArchitectureDependentCodeGenerator>
implements CodeDetector {
    private String currentFile;
    private OutputStream stream;
    private CharSequence token;
    int counter;

    public ArchitectureDependentCodeDetector(CharSequence token) {
        this.token = token;
    }

    public ArchitectureDependentCodeDetector() {
        this("/* Insert architecture dependent code here */");
    }

    @Override
    public void fileStart(String file, FileOutputStream stream) {
        this.currentFile = file;
        this.stream = stream;
        this.counter = 0;
    }

    @Override
    public void newRead(char character) {
        int n = this.counter = this.token.charAt(this.counter) == character ? this.counter + 1 : 0;
        if (this.counter == this.token.length()) {
            this.dispatchTokenDetectedEvent();
            this.counter = 0;
        }
    }

    private void dispatchTokenDetectedEvent() {
        for (ArchitectureDependentCodeGenerator extension : this.getExtensions()) {
            try {
                extension.tokenDetected(this.currentFile, this.stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected String getCodeGeneratorExtensionPoint() {
        return "icecaptools.ArchitectureDependentCodeGenerator";
    }

    @Override
    protected String getCodeGeneratorExtensionElement() {
        return "class";
    }
}

