/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.actions;

import icecaptools.Activator;
import icecaptools.ConverterJob;
import icecaptools.compiler.ArchitectureDependentCodeDetector;
import icecaptools.compiler.EclipseCCodeFormatter;
import icecaptools.compiler.EclipseNativeMethodDetector;
import icecaptools.compiler.EclipseSourceCodeLinker;
import icecaptools.conversion.ConversionConfiguration;
import icecaptools.views.DELabelProvider;
import icecaptools.views.DependencyView;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;

public class ConvertJavaFileAction
implements IObjectActionDelegate {
    private static final String CONSOLE_NAME = "Icecap tools messages";
    private IMethod entryPoint;
    private static PrintStream out = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public static PrintStream getConsolePrintStream() {
        return ConvertJavaFileAction.getConsolePrintStream(CONSOLE_NAME);
    }

    public static PrintStream getConsolePrintStream(String console_name) {
        MessageConsole myConsole = null;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (console_name.equals(existing[i].getName())) {
                myConsole = (MessageConsole)existing[i];
                break;
            }
            ++i;
        }
        if (myConsole == null) {
            myConsole = new MessageConsole(console_name, null);
            conMan.addConsoles(new IConsole[]{myConsole});
        }
        IOConsoleOutputStream stream = myConsole.newOutputStream();
        PrintStream print = new PrintStream((OutputStream)stream);
        return print;
    }

    public static void bringConsoleToFront(String console_name, boolean clear) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (console_name.equals(existing[i].getName())) {
                conMan.showConsoleView(existing[i]);
                if (clear && existing[i] instanceof IOConsole) {
                    ((IOConsole)existing[i]).clearConsole();
                }
                return;
            }
            ++i;
        }
    }

    public static void bringConsoleToFront(boolean clear) {
        ConvertJavaFileAction.bringConsoleToFront(CONSOLE_NAME, clear);
    }

    public void run(IAction action) {
        block18: {
            if (this.entryPoint != null) {
                try {
                    if (!this.entryPoint.isMainMethod()) break block18;
                    if (out == null) {
                        out = ConvertJavaFileAction.getConsolePrintStream();
                    }
                    IJavaProject javaProject = this.entryPoint.getJavaProject();
                    DependencyView methodObserver = this.getProgressView();
                    DELabelProvider deLabelProvider = methodObserver;
                    deLabelProvider.setLabelSource(this.entryPoint);
                    ConversionConfiguration config = new ConversionConfiguration();
                    try {
                        try {
                            IClasspathEntry[] requiredLibraries;
                            String[] requiredProjects;
                            IPath fileLocation;
                            ICompilationUnit selectedJavaFile = this.entryPoint.getCompilationUnit();
                            String fileName = selectedJavaFile.getElementName();
                            IResource resource = selectedJavaFile.getCorrespondingResource();
                            if (resource != null && (fileLocation = resource.getLocation()) != null) {
                                config.setInputSourceFileName(fileLocation.toOSString());
                            }
                            IResource projectRessource = javaProject.getCorrespondingResource();
                            config.setProjectResource(javaProject);
                            IPath projectLocation = projectRessource.getLocation().removeLastSegments(1);
                            IPath outputLocation = javaProject.getOutputLocation();
                            StringBuffer classPath = new StringBuffer(String.valueOf(projectLocation.toOSString()) + outputLocation.toOSString());
                            String[] stringArray = requiredProjects = javaProject.getRequiredProjectNames();
                            int n = requiredProjects.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String project = stringArray[n2];
                                classPath.append(System.getProperty("path.separator"));
                                classPath.append(projectLocation);
                                classPath.append(File.separatorChar);
                                classPath.append(project);
                                classPath.append(File.separatorChar);
                                classPath.append("bin");
                                ++n2;
                            }
                            IClasspathEntry[] iClasspathEntryArray = requiredLibraries = javaProject.getRawClasspath();
                            int n3 = requiredLibraries.length;
                            n = 0;
                            while (n < n3) {
                                IClasspathEntry entry = iClasspathEntryArray[n];
                                switch (entry.getContentKind()) {
                                    case 2: {
                                        IPath cpentry = entry.getPath();
                                        String cpitem = cpentry.toOSString();
                                        classPath.append(System.getProperty("path.separator"));
                                        classPath.append(cpitem);
                                        break;
                                    }
                                    case 1: {
                                        entry = null;
                                        break;
                                    }
                                }
                                ++n;
                            }
                            config.setClassPath(classPath.toString());
                            IPackageDeclaration[] packageDeclarations = selectedJavaFile.getPackageDeclarations();
                            String packageName = packageDeclarations.length == 1 ? packageDeclarations[0].getElementName() : "default";
                            config.setInputPackage(packageName);
                            config.setInputClass(fileName);
                            config.setEntryPointMethodName(this.entryPoint.getElementName());
                            config.setCodeFormatter(new EclipseCCodeFormatter());
                            config.setSourceCodeLinker(new EclipseSourceCodeLinker(javaProject));
                            config.setReportConversion(true);
                            config.setCodeDetector(new ArchitectureDependentCodeDetector());
                            config.setNativeMethodDetector(new EclipseNativeMethodDetector());
                            ConverterJob converterJob = new ConverterJob("Converting from " + selectedJavaFile.getElementName(), methodObserver, config, out, deLabelProvider.getCompilationRegistry());
                            converterJob.schedule();
                        }
                        catch (JavaModelException e) {
                            out.println(e.getMessage());
                            out.flush();
                        }
                        catch (Exception e) {
                            out.println(e.getMessage());
                            out.flush();
                        }
                    }
                    finally {
                        out.flush();
                    }
                }
                catch (JavaModelException e) {
                    out.println(e.getMessage());
                    out.flush();
                }
            }
        }
    }

    private DependencyView getProgressView() {
        IWorkbench wb = Activator.getDefault().getWorkbench();
        IWorkbenchWindow activeWindow = wb.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWindow.getActivePage();
        IViewPart dependencyExtentViewPart = activePage.findView("icecaptools.views.dependencyextent");
        DependencyView dependencyExtentView = null;
        if (dependencyExtentViewPart != null) {
            if (dependencyExtentViewPart instanceof DependencyView) {
                dependencyExtentView = (DependencyView)dependencyExtentViewPart;
            }
        } else {
            try {
                dependencyExtentViewPart = activePage.showView("icecaptools.views.dependencyextent", null, 3);
                if (dependencyExtentViewPart instanceof DependencyView) {
                    dependencyExtentView = (DependencyView)dependencyExtentViewPart;
                }
            }
            catch (PartInitException partInitException) {}
        }
        if (dependencyExtentView != null) {
            activePage.bringToTop((IWorkbenchPart)dependencyExtentView);
        }
        return dependencyExtentView;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        TreeSelection treeSelection;
        Object firstElement;
        if (selection != null && selection instanceof TreeSelection && (firstElement = (treeSelection = (TreeSelection)selection).getFirstElement()) instanceof IMethod) {
            IMethod iMethod;
            this.entryPoint = iMethod = (IMethod)firstElement;
        }
    }
}

