/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.IcecapIterator;
import icecaptools.ResourceManager;
import icecaptools.StreamResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;

public class TestResourceManager
extends ResourceManager {
    private String vmSourceFolder;

    public TestResourceManager(String vmSourceFolder) {
        this.vmSourceFolder = vmSourceFolder;
    }

    @Override
    public IcecapIterator<StreamResource> getResources(PrintStream out) {
        return new TestResourceIterator(out);
    }

    @Override
    public StreamResource getResource(PrintStream out, String resourceName) {
        try {
            FileInputStream stream = new FileInputStream(new File(String.valueOf(this.vmSourceFolder) + File.separatorChar + resourceName));
            StreamResource streamResource = new StreamResource(stream, resourceName);
            return streamResource;
        }
        catch (IOException e) {
            e.printStackTrace(out);
            return null;
        }
    }

    private class TestResourceIterator
    implements IcecapIterator<StreamResource> {
        private int top = 0;
        private PrintStream out;

        public TestResourceIterator(PrintStream out) {
        }

        @Override
        public boolean hasNext() {
            return this.top < TestResourceManager.this.getResourcesToLoad().length;
        }

        @Override
        public StreamResource next() {
            String resourceName = TestResourceManager.this.getResourcesToLoad()[this.top++];
            String path = String.valueOf(TestResourceManager.this.vmSourceFolder) + File.separatorChar + resourceName;
            try {
                FileInputStream stream = new FileInputStream(new File(path));
                StreamResource streamResource = new StreamResource(stream, resourceName);
                return streamResource;
            }
            catch (IOException e) {
                this.out.println("Could not open file: [" + path + "]");
                e.printStackTrace(this.out);
                return null;
            }
        }
    }
}

