/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.IcecapIterator;
import icecaptools.ResourceManager;
import icecaptools.StreamResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PluginResourceManager
extends ResourceManager {
    private String pluginName;

    public PluginResourceManager(String pluginName, String[] resources) {
        this.pluginName = pluginName;
        this.setResourcesToLoad(resources);
    }

    public PluginResourceManager() {
        this.pluginName = "icecaptools";
    }

    @Override
    public IcecapIterator<StreamResource> getResources(PrintStream out) {
        return new PluginResourceIterator(out);
    }

    @Override
    public StreamResource getResource(PrintStream out, String resourceName) {
        Bundle bundle = Platform.getBundle((String)this.pluginName);
        String resourcePath = "resources/" + resourceName;
        URL resource = bundle.getResource(resourcePath);
        try {
            if (resource != null) {
                InputStream stream = resource.openStream();
                StreamResource streamResource = new StreamResource(stream, resourceName);
                return streamResource;
            }
            out.println("Could not get resource [" + resourcePath + " from plugin [" + this.pluginName + "]");
        }
        catch (IOException e) {
            e.printStackTrace(out);
        }
        return null;
    }

    public class PluginResourceIterator
    implements IcecapIterator<StreamResource> {
        private int top;
        private Bundle bundle;
        private PrintStream out;

        public PluginResourceIterator(PrintStream out) {
            this.bundle = Platform.getBundle((String)PluginResourceManager.this.pluginName);
            this.out = out;
            this.top = this.bundle == null ? PluginResourceManager.this.getResourcesToLoad().length : 0;
        }

        @Override
        public boolean hasNext() {
            return this.top < PluginResourceManager.this.getResourcesToLoad().length;
        }

        @Override
        public StreamResource next() {
            String resourceName = PluginResourceManager.this.getResourcesToLoad()[this.top++];
            URL resource = this.bundle.getResource("resources/" + resourceName);
            try {
                InputStream stream = resource.openStream();
                StreamResource streamResource = new StreamResource(stream, resourceName);
                return streamResource;
            }
            catch (IOException e) {
                e.printStackTrace(this.out);
                return null;
            }
        }
    }
}

