/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.BNode;
import icecaptools.ClassfileUtils;
import icecaptools.MethodOrFieldDesc;
import icecaptools.NewList;
import java.util.ArrayList;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public abstract class MethodCallBNode
extends BNode {
    protected String className;
    protected String methodName;
    protected String methodSig;
    protected ArrayList<JavaClass> targetClasses;
    private int numArgs;
    private MethodOrFieldDesc calleeDescriptor;
    private NewList nativesChecked;
    private JavaClass targetClazz;
    private Method targetMetod;

    public MethodCallBNode(int address, String className, String methodName, String methodSig, String locationClass, String locationMethod, String locationMethodSignature) {
        super(address, locationClass, locationMethod, locationMethodSignature);
        this.className = className;
        this.methodName = methodName;
        this.methodSig = methodSig;
        this.targetClasses = new ArrayList();
        this.numArgs = -1;
        this.nativesChecked = new NewList();
    }

    public boolean isNativesChecked(NewList newList) {
        return newList.lessThanOrEquals(this.nativesChecked);
    }

    public void setNativesChecked(NewList newList) {
        this.nativesChecked = new NewList(newList);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodSig() {
        return this.methodSig;
    }

    @Override
    public int extend() throws Exception {
        if (this.rawBytes.length == 3) {
            int extendedLength = this.getExtendedLength();
            byte[] newRawBytes = new byte[extendedLength];
            newRawBytes[0] = this.rawBytes[0];
            int i = 1;
            while (i < this.rawBytes.length) {
                newRawBytes[i + 1] = this.rawBytes[i];
                ++i;
            }
            this.rawBytes = newRawBytes;
            return extendedLength - 3;
        }
        return super.extend();
    }

    protected int getExtendedLength() {
        return 4;
    }

    @Override
    public void relocateForward(int address, int extension) {
    }

    @Override
    public void relocateBackward(int address, int extension) {
    }

    @Override
    public boolean requiresExtension() {
        return false;
    }

    @Override
    protected String print() {
        return "call " + this.className + "." + this.methodName;
    }

    public void addTarget(JavaClass targetClass) {
        if (!this.targetClasses.contains(targetClass)) {
            this.targetClasses.add(targetClass);
        }
    }

    public int getNumberOfTargets() {
        return this.targetClasses.size();
    }

    public String getTargetClassName() {
        return this.targetClasses.get(0).getClassName();
    }

    public void setNumArgs(int numArgs) {
        this.numArgs = numArgs;
    }

    public int getNumArgs() {
        return this.numArgs;
    }

    public void setMethodDescriptor(MethodOrFieldDesc callee) {
        this.calleeDescriptor = callee;
    }

    public MethodOrFieldDesc getMethodDescriptor() {
        return this.calleeDescriptor;
    }

    public Method findMethodInClass(JavaClass clazz) {
        if (this.targetClazz != clazz) {
            this.targetClazz = clazz;
            this.targetMetod = ClassfileUtils.findMethodInClass(clazz, this.getMethodName(), this.getMethodSig());
        }
        return this.targetMetod;
    }

    public boolean isTarget(JavaClass t) {
        return this.targetClasses.contains(t);
    }
}

