/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.util.Repository;

public class LambdaClass
extends JavaClass {
    private static final long serialVersionUID = 1L;
    public static final String LAMBDACLASSPOSTFIX = "$lambda";
    private String className;
    private Method[] methods;
    private static ArrayList<Method> lambdaMethods = new ArrayList();

    public LambdaClass(String className, JavaClass iface) {
        super(iface.getClassNameIndex(), iface.getSuperclassNameIndex(), iface.getFileName(), iface.getMajor(), iface.getMinor(), iface.getAccessFlags(), iface.getConstantPool(), iface.getInterfaceIndices(), iface.getFields(), iface.getMethods(), iface.getAttributes());
        this.className = className;
    }

    public static boolean isLambdaClass(String className) {
        return className.endsWith(LAMBDACLASSPOSTFIX);
    }

    public static String getInterfaceName(String className) {
        return LambdaClass.getToken(className, 0);
    }

    private static String getToken(String str, int index) {
        int start = str.indexOf("$$");
        while (index > 0) {
            str = str.substring(start + 2);
            start = str.indexOf("$$");
            --index;
        }
        if (start != -1) {
            return str.substring(0, start);
        }
        return str;
    }

    void unimplemented() {
        System.out.println("unimplemented");
    }

    public void accept(Visitor v) {
        this.unimplemented();
        super.accept(v);
    }

    public void dump(File file) throws IOException {
        this.unimplemented();
        super.dump(file);
    }

    public void dump(String _file_name) throws IOException {
        this.unimplemented();
        super.dump(_file_name);
    }

    public byte[] getBytes() {
        this.unimplemented();
        return super.getBytes();
    }

    public void dump(OutputStream file) throws IOException {
        this.unimplemented();
        super.dump(file);
    }

    public void dump(DataOutputStream file) throws IOException {
        this.unimplemented();
        super.dump(file);
    }

    public Attribute[] getAttributes() {
        this.unimplemented();
        return super.getAttributes();
    }

    public AnnotationEntry[] getAnnotationEntries() {
        this.unimplemented();
        return super.getAnnotationEntries();
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        this.unimplemented();
        return super.getPackageName();
    }

    public int getClassNameIndex() {
        this.unimplemented();
        return super.getClassNameIndex();
    }

    public ConstantPool getConstantPool() {
        String implementationClassName = LambdaClass.getToken(this.className, 1);
        try {
            JavaClass implementationClass = org.apache.bcel.Repository.lookupClass((String)implementationClassName);
            return implementationClass.getConstantPool();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Field[] getFields() {
        return new Field[0];
    }

    public String getFileName() {
        this.unimplemented();
        return super.getFileName();
    }

    public String[] getInterfaceNames() {
        this.unimplemented();
        return super.getInterfaceNames();
    }

    public int[] getInterfaceIndices() {
        this.unimplemented();
        return super.getInterfaceIndices();
    }

    public int getMajor() {
        this.unimplemented();
        return super.getMajor();
    }

    public Method[] getMethods() {
        if (this.methods == null) {
            String interfaceName = LambdaClass.getToken(this.className, 0);
            String implementationClassName = LambdaClass.getToken(this.className, 1);
            String implementationMethodName = LambdaClass.getToken(this.className, 2);
            implementationMethodName = implementationMethodName.substring(0, implementationMethodName.length() - LAMBDACLASSPOSTFIX.length());
            try {
                Method[] methods;
                JavaClass implementationClass = org.apache.bcel.Repository.lookupClass((String)implementationClassName);
                Method[] methodArray = methods = implementationClass.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (method.getName().equals(implementationMethodName)) {
                        Method[] methodArray2 = new Method[1];
                        JavaClass iface = org.apache.bcel.Repository.lookupClass((String)interfaceName);
                        Method[] interfaceMethods = iface.getMethods();
                        String methodName = interfaceMethods[0].getName();
                        ConstantPool constantPool = implementationClass.getConstantPool();
                        Method implementationMethod = method.copy(constantPool);
                        Constant[] constants = constantPool.getConstantPool();
                        Constant[] extendedConstant = new Constant[constants.length + 1];
                        int i = 0;
                        while (i < constants.length) {
                            extendedConstant[i] = constants[i];
                            ++i;
                        }
                        ConstantUtf8 implementationMethodNameConstant = new ConstantUtf8(methodName);
                        extendedConstant[constants.length] = implementationMethodNameConstant;
                        implementationMethod.setConstantPool(new ConstantPool(extendedConstant));
                        implementationMethod.setNameIndex(constants.length);
                        methodArray2[0] = implementationMethod;
                        LambdaClass.registerLambdaMethod(implementationMethod);
                        this.methods = methodArray2;
                    }
                    ++n2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return this.methods;
    }

    private static void registerLambdaMethod(Method implementationMethod) {
        lambdaMethods.add(implementationMethod);
    }

    public static boolean isLambdaMethod(Method javaMethod) {
        Iterator<Method> lambdas = lambdaMethods.iterator();
        while (lambdas.hasNext()) {
            if (lambdas.next() != javaMethod) continue;
            return true;
        }
        return false;
    }

    public Method getMethod(java.lang.reflect.Method m) {
        this.unimplemented();
        return super.getMethod(m);
    }

    public int getMinor() {
        this.unimplemented();
        return super.getMinor();
    }

    public String getSourceFileName() {
        this.unimplemented();
        return super.getSourceFileName();
    }

    public String getSuperclassName() {
        return "java.lang.Object";
    }

    public int getSuperclassNameIndex() {
        this.unimplemented();
        return super.getSuperclassNameIndex();
    }

    public void setAttributes(Attribute[] attributes) {
        this.unimplemented();
        super.setAttributes(attributes);
    }

    public void setClassName(String class_name) {
        this.unimplemented();
        super.setClassName(class_name);
    }

    public void setClassNameIndex(int class_name_index) {
        this.unimplemented();
        super.setClassNameIndex(class_name_index);
    }

    public void setConstantPool(ConstantPool constant_pool) {
        this.unimplemented();
        super.setConstantPool(constant_pool);
    }

    public void setFields(Field[] fields) {
        this.unimplemented();
        super.setFields(fields);
    }

    public void setFileName(String file_name) {
        this.unimplemented();
        super.setFileName(file_name);
    }

    public void setInterfaceNames(String[] interface_names) {
        this.unimplemented();
        super.setInterfaceNames(interface_names);
    }

    public void setInterfaces(int[] interfaces) {
        this.unimplemented();
        super.setInterfaces(interfaces);
    }

    public void setMajor(int major) {
        this.unimplemented();
        super.setMajor(major);
    }

    public void setMethods(Method[] methods) {
        this.unimplemented();
        super.setMethods(methods);
    }

    public void setMinor(int minor) {
        this.unimplemented();
        super.setMinor(minor);
    }

    public void setSourceFileName(String source_file_name) {
        this.unimplemented();
        super.setSourceFileName(source_file_name);
    }

    public void setSuperclassName(String superclass_name) {
        this.unimplemented();
        super.setSuperclassName(superclass_name);
    }

    public void setSuperclassNameIndex(int superclass_name_index) {
        this.unimplemented();
        super.setSuperclassNameIndex(superclass_name_index);
    }

    public String toString() {
        this.unimplemented();
        return super.toString();
    }

    public JavaClass copy() {
        this.unimplemented();
        return super.copy();
    }

    public Repository getRepository() {
        return super.getRepository();
    }

    public void setRepository(Repository repository) {
        super.setRepository(repository);
    }

    public boolean implementationOf(JavaClass inter) throws ClassNotFoundException {
        return inter.getClassName().equals(LambdaClass.getInterfaceName(this.className));
    }

    public JavaClass getSuperClass() throws ClassNotFoundException {
        return org.apache.bcel.Repository.lookupClass((String)"java.lang.Object");
    }

    public JavaClass[] getSuperClasses() throws ClassNotFoundException {
        this.unimplemented();
        return super.getSuperClasses();
    }

    public JavaClass[] getInterfaces() throws ClassNotFoundException {
        this.unimplemented();
        return super.getInterfaces();
    }

    public JavaClass[] getAllInterfaces() throws ClassNotFoundException {
        String interfaceName = LambdaClass.getToken(this.className, 0);
        JavaClass[] interfaces = new JavaClass[]{org.apache.bcel.Repository.lookupClass((String)interfaceName)};
        return interfaces;
    }

    public boolean equals(Object obj) {
        this.unimplemented();
        return super.equals(obj);
    }

    public int compareTo(JavaClass obj) {
        this.unimplemented();
        return super.compareTo(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

