/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.AbstractHVMProperties;
import java.util.Properties;

public class HVMLoadedProperties
extends AbstractHVMProperties {
    private Properties props;

    public HVMLoadedProperties(Properties props) {
        this.props = props;
    }

    @Override
    public String getProgmemStart() {
        return this.getProp("PROGMEMSTART");
    }

    @Override
    public String getProgmemEnd() {
        return this.getProp("PROGMEMEND");
    }

    private String getProp(String key) {
        String prop = this.props.getProperty(key);
        if (prop != null) {
            return this.trimAndClean(this.props.getProperty(key));
        }
        return "";
    }

    @Override
    public String getNewlineSequence() {
        String prop = this.getProp("NEWLINESEQ");
        if (prop.length() > 0) {
            return prop;
        }
        return "\n";
    }

    @Override
    public boolean includeMethodAndClassNames() {
        String prop = this.getProp("INCLUDENAMES");
        return prop.length() <= 0 || !prop.equalsIgnoreCase("false");
    }

    @Override
    public boolean isIncludeJMLMethods() {
        String prop = this.getProp("INCLUDEJMLMETHODS");
        return prop.length() > 0 && prop.equalsIgnoreCase("true");
    }

    @Override
    public void setIncludeJMLMethods(boolean includeJMLMethods) {
    }

    @Override
    public String getProperty(String key) {
        return this.props.getProperty(key);
    }
}

