/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.AdditionalResourceManager;
import icecaptools.AnalysisObserver;
import icecaptools.BNode;
import icecaptools.BNodeUtils;
import icecaptools.CFuncInfo;
import icecaptools.CanceledByUserException;
import icecaptools.FieldOffsetCalculator;
import icecaptools.IcecapCFunc;
import icecaptools.IcecapCVar;
import icecaptools.IcecapIterator;
import icecaptools.IcecapProgressMonitor;
import icecaptools.LocalVariableUsageAnalyser;
import icecaptools.MethodEntryPoints;
import icecaptools.MethodIdentifier;
import icecaptools.MethodOrFieldDesc;
import icecaptools.NativeFieldInfo;
import icecaptools.NewArrayBNode;
import icecaptools.ResourceManager;
import icecaptools.RestartableMethodObserver;
import icecaptools.StackDepthAnalyser;
import icecaptools.SwitchBNode;
import icecaptools.UsedElementsObserver;
import icecaptools.compiler.ByteCodePatcher;
import icecaptools.compiler.Compiler;
import icecaptools.compiler.FieldInfo;
import icecaptools.compiler.ICompilationRegistry;
import icecaptools.compiler.IDGenerator;
import icecaptools.compiler.IcecapByteCodePatcher;
import icecaptools.compiler.MemorySegment;
import icecaptools.compiler.RequiredMethodsManager;
import icecaptools.compiler.VirtualTable;
import icecaptools.compiler.utils.CompilerUtils;
import icecaptools.conversion.ConversionConfiguration;
import icecaptools.conversion.Converter;
import icecaptools.conversion.DependencyExtent;
import icecaptools.stackanalyser.ProducerConsumerAnalyser;
import icecaptools.stackanalyser.StackArrayReferencesAnalyser;
import icecaptools.stackanalyser.StackReferencesAnalyser;
import icecaptools.stackanalyser.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.Repository;

public class CompilationSequence {
    public static byte[] failingCode;
    private AdditionalResourceManager additionalResourceManager;
    private DependencyExtent extent;
    private Observer observer;
    private IDGenerator idGen;
    private ByteCodePatcher patcher;
    private ConversionConfiguration config;

    public void startCompilation(PrintStream out, RestartableMethodObserver methodObserver, ConversionConfiguration config, IcecapProgressMonitor progressMonitor, ICompilationRegistry cregistry, String outputFolder, boolean compile) throws Throwable {
        boolean supportLoading = false;
        this.config = config;
        UsedElementsObserver usedElementsObserver = new UsedElementsObserver();
        usedElementsObserver.setProgressMonitor(progressMonitor);
        this.observer = new Observer(methodObserver, usedElementsObserver);
        Converter converter = new Converter(out, this.observer, cregistry, supportLoading);
        converter.setObserver(this.observer);
        VirtualTable.init();
        if (converter.startConversion(config) != null) {
            this.extent = converter.getDependencyExtent();
            this.idGen = new IDGenerator();
            RequiredMethodsManager rmManager = new RequiredMethodsManager(this.idGen, supportLoading);
            cregistry = new CompilerRegistry(cregistry, rmManager);
            converter.getCallGraph().analyse(this.extent, cregistry);
            Iterator<MethodEntryPoints> methods = this.extent.getMethods();
            while (methods.hasNext()) {
                MethodEntryPoints next = methods.next();
                if (next.getMethod().isStatic() || !next.getMethod().isSynchronized()) continue;
                this.observer.registerLockingType(next.getClazz().getClassName());
            }
            FieldOffsetCalculator foCalc = new FieldOffsetCalculator();
            foCalc.calculate(usedElementsObserver.getUsedClasses(), usedElementsObserver);
            this.patcher = new IcecapByteCodePatcher(usedElementsObserver, this.idGen, foCalc, supportLoading);
            methods = this.extent.getMethods();
            int methodCount = 0;
            int maxSwitchSize = 0;
            while (methods.hasNext()) {
                MethodEntryPoints next = methods.next();
                ++methodCount;
                ProducerConsumerAnalyser.annotate(next);
                StackReferencesAnalyser stackReferences = new StackReferencesAnalyser(next, next.getClazz());
                try {
                    stackReferences.analyseStackUsage();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Exception("Stack analysis failed! [" + next.getClazz().getClassName() + ", " + next.getMethod().getName() + "]");
                }
                StackArrayReferencesAnalyser stackArrayReferences = new StackArrayReferencesAnalyser(next, next.getClazz());
                try {
                    stackArrayReferences.analyseStackUsage();
                }
                catch (Exception exception) {
                    throw new Exception("Array usage analysis failed!");
                }
                LocalVariableUsageAnalyser lvAnalyser = new LocalVariableUsageAnalyser(next);
                lvAnalyser.analyse();
                ArrayList<BNode> bnodes = next.getBNodes();
                String className = next.getClazz().getClassName();
                String targetMethodName = next.getMethod().getName();
                String targetMethodSignature = next.getMethod().getSignature();
                int i = 0;
                while (i < bnodes.size()) {
                    SwitchBNode switchNode;
                    BNode current = bnodes.get(i);
                    switch (current.getOpCode()) {
                        case -78: 
                        case -77: 
                        case -76: 
                        case -75: 
                        case -74: 
                        case -73: 
                        case -72: 
                        case -71: 
                        case -70: 
                        case -69: 
                        case -64: 
                        case -63: 
                        case 18: 
                        case 19: 
                        case 20: {
                            this.patcher.registerByteCode(className, targetMethodName, targetMethodSignature, current);
                            break;
                        }
                        case -68: 
                        case -67: {
                            this.patcher.registerByteCode(className, targetMethodName, targetMethodSignature, current);
                            if (!stackArrayReferences.isFlashArray(className, targetMethodName, targetMethodSignature, current.getOriginalAddress())) break;
                            ((NewArrayBNode)current).setFlashArray();
                            break;
                        }
                        case -59: {
                            this.patcher.registerByteCode(className, targetMethodName, targetMethodSignature, current);
                        }
                    }
                    switch (current.getOpCode()) {
                        case -84: 
                        case -83: 
                        case -82: 
                        case -81: 
                        case -80: 
                        case -79: 
                        case -76: 
                        case -75: 
                        case -74: 
                        case -73: 
                        case -71: 
                        case -68: 
                        case -66: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: {
                            current.setStackLayout(stackReferences.getStackLayout(current.getAddress()));
                        }
                    }
                    switch (current.getOpCode()) {
                        case -62: {
                            ArrayList<String> types = Util.getCellType(next, current.getAinfo().entryStack.peek());
                            this.observer.registerLockingTypes(types);
                        }
                    }
                    if ((current.getOpCode() == -85 || current.getOpCode() == -86) && (switchNode = (SwitchBNode)current).getNumberOfTargets() > maxSwitchSize) {
                        maxSwitchSize = switchNode.getNumberOfTargets();
                    }
                    ++i;
                }
                MethodOrFieldDesc mdesc = Util.getMethodOrFieldDesc(next.getClazz(), next.getMethod());
                if (!Compiler.compileMethod(cregistry, next.getMethod(), mdesc)) {
                    int i2 = 0;
                    while (i2 < bnodes.size()) {
                        this.observer.byteCodeUsed(bnodes.get(i2).getOpCode());
                        ++i2;
                    }
                }
                BNodeUtils.collectExceptions(next);
                Converter.extendBNodes(bnodes, next.getMethod().getCode().getExceptionTable());
                ArrayList<Byte> newCode = new ArrayList<Byte>();
                int index = 0;
                while (index < bnodes.size()) {
                    BNode node = bnodes.get(index);
                    byte[] rawBytes = node.getRawBytes();
                    int j = 0;
                    while (j < rawBytes.length) {
                        newCode.add(rawBytes[j]);
                        ++j;
                    }
                    ++index;
                }
                byte[] newByteCodes = new byte[newCode.size()];
                int index2 = 0;
                while (index2 < newByteCodes.length) {
                    newByteCodes[index2] = (Byte)newCode.get(index2);
                    ++index2;
                }
                next.getMethod().getCode().setCode(newByteCodes);
                failingCode = newByteCodes;
            }
            StackDepthAnalyser sda = new StackDepthAnalyser(converter.getCallGraph());
            sda.analyse(config);
            if (compile) {
                Compiler compiler = new Compiler(this.idGen, rmManager, config, supportLoading);
                ResourceManager rManager = config.getResourceManager();
                if (rManager == null) {
                    if (this.additionalResourceManager == null) {
                        this.additionalResourceManager = new AdditionalResourceManager();
                    }
                    rManager = this.additionalResourceManager.createResorceManager();
                }
                compiler.writeClassesToFile("classes", this.patcher, config, foCalc, usedElementsObserver, outputFolder, cregistry, rManager, out);
                compiler.writeMethodsToFile("methods", usedElementsObserver, this.patcher, converter, config, outputFolder, cregistry, converter.getDependencyExtent(), progressMonitor);
                this.writeTimingInformation(outputFolder, out, sda, foCalc, this.patcher, maxSwitchSize, usedElementsObserver.getMaxVtableSize());
                if (config.reportConversion()) {
                    CompilerUtils.reportConversion(methodCount);
                }
                out.println("Code memory: " + MemorySegment.codeBytes + " bytes");
                out.println("Data memory: " + MemorySegment.dataBytes + " bytes");
            }
        } else {
            File methodsFile = new File(String.valueOf(Compiler.checkOutputFolder(outputFolder)) + "methods" + ".c");
            File classesFile = new File(String.valueOf(Compiler.checkOutputFolder(outputFolder)) + "classes" + ".c");
            if (methodsFile.exists()) {
                methodsFile.delete();
            }
            if (classesFile.exists()) {
                classesFile.delete();
            }
            throw new Exception("Compilation failed - check logs in console");
        }
        out.println("Dependency extent: classes[" + usedElementsObserver.numberOfUsedClasses() + "], methods[" + usedElementsObserver.numberOfUsedMethods() + "]");
        Repository.clearCache();
    }

    private void writeTimingInformation(String outputFolder, PrintStream out, StackDepthAnalyser sda, FieldOffsetCalculator foCalc, ByteCodePatcher patcher, int maxSwitchSize, int maxVTableSize) {
        FileOutputStream tinfo = null;
        try {
            StringBuffer tinfoPath = new StringBuffer();
            tinfoPath.append(outputFolder);
            if (!outputFolder.endsWith(String.valueOf(File.separatorChar))) {
                tinfoPath.append(File.separatorChar);
            }
            tinfoPath.append("tinfo.h");
            tinfo = new FileOutputStream(tinfoPath.toString());
            StringBuffer content = new StringBuffer();
            content.append("/* Maximum stack depth: \n");
            LinkedList<MethodIdentifier> maxStack = sda.getMaxStack();
            for (MethodIdentifier current : maxStack) {
                content.append("   " + current.getClassName() + "." + current.getName() + "(" + current.getSignature() + ")\n");
            }
            content.append("*/\n");
            content.append("#define MAX_APP_STACK " + sda.calculateMaxDepth() + "\n");
            content.append("/* Maximum class heirarchy: \n");
            LinkedList<String> heirarchy = foCalc.getMaxClassHeirarchy();
            for (String current : heirarchy) {
                content.append("   " + current + "\n");
            }
            content.append("*/\n");
            content.append("#define MAX_CLASS_HEIRARCHY " + heirarchy.size() + "\n");
            content.append("/* Maximum lookup/tableswitch jump table size */\n");
            content.append("#define MAX_LOOKUPTABLE_SWITCH_SIZE " + maxSwitchSize + "\n");
            content.append("/* Maximum invokevirtual/interface jump table size */\n");
            content.append("#define MAX_INVOKE_TABLE_SIZE " + maxVTableSize + "\n");
            tinfo.write(content.toString().getBytes());
            tinfo.flush();
            tinfo.close();
        }
        catch (FileNotFoundException e) {
            out.println(e.getMessage());
        }
        catch (IOException e) {
            out.println(e.getMessage());
        }
    }

    public DependencyExtent getDependencyExtent() {
        return this.extent;
    }

    public AnalysisObserver getObserver() {
        return this.observer;
    }

    public ByteCodePatcher getPatcher() {
        return this.patcher;
    }

    public ConversionConfiguration getConfig() {
        return this.config;
    }

    public IDGenerator getIDGen() {
        return this.idGen;
    }

    private static class CompilerRegistry
    implements ICompilationRegistry {
        private ICompilationRegistry delegate;
        private RequiredMethodsManager rmManager;

        public CompilerRegistry(ICompilationRegistry cregistry, RequiredMethodsManager rmManager) {
            this.delegate = cregistry;
            this.rmManager = rmManager;
        }

        @Override
        public boolean isMethodCompiled(MethodOrFieldDesc mdesc) {
            if (this.rmManager.isRequieredMethod(mdesc)) {
                return false;
            }
            return this.delegate.isMethodCompiled(mdesc);
        }

        @Override
        public boolean isMethodExcluded(String clazz, String targetMethodName, String targetMethodSignature) {
            return this.delegate.isMethodExcluded(clazz, targetMethodName, targetMethodSignature);
        }

        @Override
        public boolean alwaysClearOutputFolder() {
            return this.delegate.alwaysClearOutputFolder();
        }
    }

    private static class Observer
    implements RestartableMethodObserver,
    AnalysisObserver {
        private RestartableMethodObserver rdelegate;
        private AnalysisObserver adelegate;

        public Observer(RestartableMethodObserver rdelegate, AnalysisObserver adelegate) {
            this.rdelegate = rdelegate;
            this.adelegate = adelegate;
        }

        @Override
        public void methodCodeUsed(String className, String targetMethodName, String targetMethodSignature, boolean report) throws CanceledByUserException {
            this.rdelegate.methodCodeUsed(className, targetMethodName, targetMethodSignature, report);
            this.adelegate.methodCodeUsed(className, targetMethodName, targetMethodSignature, report);
        }

        @Override
        public void restart() {
            this.rdelegate.restart();
        }

        @Override
        public void refresh() {
            this.rdelegate.refresh();
        }

        @Override
        public void classUsed(String newType) {
            this.adelegate.classUsed(newType);
        }

        @Override
        public void classFieldUsed(String className, String fieldName) {
            this.adelegate.classFieldUsed(className, fieldName);
        }

        @Override
        public void interfaceUsed(String className) {
            this.adelegate.interfaceUsed(className);
        }

        @Override
        public boolean isMethodUsed(String className, String targetMethodName, String targetMethodSignature) {
            return this.adelegate.isMethodUsed(className, targetMethodName, targetMethodSignature);
        }

        @Override
        public boolean isClassFieldUsed(String className, String fieldName) {
            return this.adelegate.isClassFieldUsed(className, fieldName);
        }

        @Override
        public boolean isInterfaceUsed(String className) {
            return this.adelegate.isInterfaceUsed(className);
        }

        @Override
        public IcecapIterator<MethodOrFieldDesc> getUsedMethods() {
            return this.adelegate.getUsedMethods();
        }

        @Override
        public Iterator<String> getUsedClasses() {
            return this.adelegate.getUsedClasses();
        }

        @Override
        public void setProgressMonitor(IcecapProgressMonitor progressMonitor) {
            this.adelegate.setProgressMonitor(progressMonitor);
        }

        @Override
        public boolean isClassUsed(String className) {
            return this.adelegate.isClassUsed(className);
        }

        @Override
        public void registerLockingTypes(ArrayList<String> types) {
            this.adelegate.registerLockingTypes(types);
        }

        @Override
        public boolean isLockingType(String className) {
            return this.adelegate.isLockingType(className);
        }

        @Override
        public void registerLockingType(String type) {
            this.adelegate.registerLockingType(type);
        }

        @Override
        public void byteCodeUsed(byte opCode) {
            this.adelegate.byteCodeUsed(opCode);
        }

        @Override
        public boolean isBytecodeUsed(int i) {
            return this.adelegate.isBytecodeUsed(i);
        }

        @Override
        public void registerNativeField(String containingClass, FieldInfo field, IcecapCVar cvar) {
            this.adelegate.registerNativeField(containingClass, field, cvar);
        }

        @Override
        public NativeFieldInfo isNativeField(String containingClass, FieldInfo field) {
            return this.adelegate.isNativeField(containingClass, field);
        }

        @Override
        public void classInitializerUsed(String className) {
            this.adelegate.classInitializerUsed(className);
        }

        @Override
        public Iterator<String> getUsedClassInitializers() {
            return this.adelegate.getUsedClassInitializers();
        }

        @Override
        public IcecapIterator<MethodOrFieldDesc> getUsedMethods(String nextClass) {
            return this.adelegate.getUsedMethods(nextClass);
        }

        @Override
        public void reportVtableSize(int s) {
            this.adelegate.reportVtableSize(s);
        }

        @Override
        public int getMaxVtableSize() {
            return this.adelegate.getMaxVtableSize();
        }

        @Override
        public void registerCFunc(String className, String name, String signature, IcecapCFunc cfunc) {
            this.adelegate.registerCFunc(className, name, signature, cfunc);
        }

        @Override
        public CFuncInfo isCFunc(String className, String name, String signature) {
            return this.adelegate.isCFunc(className, name, signature);
        }

        @Override
        public IcecapIterator<CFuncInfo> getCFunctions() throws Exception {
            return this.adelegate.getCFunctions();
        }
    }
}

