import javax.realtime.Clock;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;


public class Producer extends PeriodicEventHandler {

	private PersistentSignal _event;

	public Producer(PersistentSignal log, long period_ms, long offset_ms) 
	{
		super(//priority
				  new PriorityParameters(PriorityScheduler.instance().getNormPriority()),
				  //period
				  new PeriodicParameters(new RelativeTime(offset_ms, 0), new RelativeTime(period_ms, 0)),
				  //storage
				  new StorageConfigurationParameters(32768, 4096, 4096),
				  //size
				  65523,
				  //name
				  "Producer"
			      );
		this._event = log;
	}

	public void handleEvent() {

		/* reset signal at each release */
		
		this._event.reset();
		this._event.fire();
		
		/* do some computation */
		System.out.println("+ Producer - starting  computation ");// + Clock.getRealtimeClock().getTime());
		for (int i = 0; i < 100; i++) i+=i;
		System.out.println("+ Producer - finishing computation ");// + Clock.getRealtimeClock().getTime());
		
		/* check if output is done */
		if (this._event.isSet()) System.out.println("+ Producer - output done\n");
		else System.out.println("+ Producer - output not done yet");
		
	}

}
