import javax.realtime.AperiodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RealtimeThread;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;

public class Consumer extends AperiodicEventHandler {

	/*
	 * Reference to MissionMemory
	 */
	private Buffer buffer;

	public Consumer(Buffer buffer) {
		
		super(//priority
			  new PriorityParameters(PriorityScheduler.instance().getMaxPriority()),
			  //release
			  new AperiodicParameters(),
			  //storage
			  new StorageConfigurationParameters(32768, 4096, 4096),
			  //size
		      32768,
			  //name
			  "Consumer"
		      );
		
		this.buffer = buffer;
	}

	public void handleEvent() {
		System.out.println("** Consumer executing in " + ((ManagedMemory) RealtimeThread.getCurrentMemoryArea()).toString());
		
		/*
		 * Get a reference to the new object
		 */
		Object data = buffer.get();

		/*
		 * Confirm we can use the object
		 */
		System.out.println("2. Object.toString() : " + (data.toString()) + "\n");		
	}
}
