import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.Services;

/**
 * A bivalued persistent signal
 * Extends an AperiodicEvent
 * Used for propagation of completeness 
 * information from Worker to Producer
 * @author ish503 *
 */
public class PersistentSignal extends AperiodicEvent {
	
	/*
	 * Records the internal state of the signal
	 */
	private boolean _set;
	
	public PersistentSignal(){
		super();
		
		/*
		 * Set the ceiling priority for this shared object
		 * used by Priority Ceiling Emulation protocol
		 * Worker is at max priority
		 */
		Services.setCeiling(this, PriorityScheduler.instance().getMaxPriority());
		
		this._set = false;
	}
	
	/**
	 * Resets the state of the signal
	 */
	public synchronized void reset()
	{
		this._set = false;
	}

	/**
	 * Sets the state of the signal
	 */
	public synchronized void set() {
		this._set = true;
	}
	
	/**
	 * Observes the state of the signal
	 * @return true if the signal is set
	 */
	public synchronized boolean isSet()
	{
		return this._set;
	}
}
