import javax.realtime.Clock;
import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.AperiodicEventHandler;

/**
 * A bivalued persistent signal
 * Extends an AperiodicEvent
 * Used for propagation of completeness 
 * information from Worker to Producer
 * @author ish503 *
 */
public class PersistentSignal extends AperiodicEvent {
	
	/*
	 * Records the internal state of the signal
	 */
	private boolean _set;
	
	public PersistentSignal(AperiodicEventHandler handler){
		super(handler);
		
		this._set = false;
	}
	
	/**
	 * Resets the state of the signal
	 */
	public synchronized void reset()
	{
		this._set = false;
	}

	/**
	 * Sets the state of the signal
	 */
	public synchronized void set() {
		this._set = true;
	}
	
	/**
	 * Observes the state of the signal
	 * @return true if the signal is set
	 */
	public synchronized boolean isSet()
	{
		return this._set;
	}
	
//	public void fire(){
//		System.out.println("++ Signal fired ++ " + Clock.getRealtimeClock().getTime());
//		super.fire();
//	}
}

