import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.Mission;


public class MainMission extends Mission {
	
	public long missionMemorySize() {
		return 1000000;
	}
	
	protected void initialize() {
		System.out.println("Initializing main mission");		
		
		/*
		 * Create Launch handler
		 */
		AperiodicEventHandler launchHandler = new LaunchHandler();
		
		// launch event releases Launch handler
		AperiodicEvent launch = new AperiodicEvent(launchHandler); 
		
		// barrier for 2, triggers launch event when ready to proceed
		Barrier barrier = new Barrier(2, launch);
		
		/*
		 * Create Fire1 and Fire2 AEH
		 * Pass a reference to the shared barrier
		 * ManagedHandlers register themselves upon creation
		 */
		FireHandler fireHandler1 = new FireHandler(barrier, 0);
		FireHandler fireHandler2 = new FireHandler(barrier, 1);
		
		/* The fire1 and fire2 events release their handlers. */
		AperiodicEvent fire1 = new AperiodicEvent(fireHandler1); 	
		AperiodicEvent fire2 = new AperiodicEvent(fireHandler2); 
		
		/*
		 * Create PEHs that represent buttons
		 * that generate event occurences.
		 */
		new Button(fire1, 2000, 0);	//every 2s
		new Button(fire2, 10000, 10000);  //every 10s + 10s offset
	}

}
