import javax.realtime.AperiodicParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;

public class FireHandler extends AperiodicEventHandler {

	/*
	 * Reference to MissionMemory
	 */
	private Barrier barrier;
	private int id;

	public FireHandler(Barrier barrier, int id) {
		
		super(//priority
			  new PriorityParameters(PriorityScheduler.instance().getMaxPriority()),
			  //release
			  new AperiodicParameters(),
			  //storage
			  new StorageConfigurationParameters(32768, 4096, 4096),
			  //size
		      32768,
			  //name
			  "SingleHandler"
		      );
		
		this.barrier = barrier;
		this.id = id;
	}

	public void handleEvent() {
			System.out.println("\n** Fire" + this.id +" is executing **");
			
			/*
			 * If we have already triggere the barrier,
			 * do not retrigger
			 */
			if (barrier.isAlreadyTriggered(this.id)) 
			{
				System.out.println(this.id + ". Fire" + this.id + " - barrier already triggered **\n");
				return;
			}
			else 
			{
				System.out.println(this.id + ". Fire" + this.id + " - triggering barrier **\n");			
				barrier.trigger(this.id);
			}
	}
}
