import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.Mission;


public class MainMission extends Mission {
	
	public long missionMemorySize() {
		return 1000000;
	}
	
	public void initialize() {
		System.out.println("Initializing main mission");		
		
		/* The launch event triggers the Launch handler. */
		AperiodicEvent launch = new AperiodicEvent(); 
		
		/*
		 * Create Launch AEH
		 * Pass a reference to the shared barrier
		 * ManagedHandlers need to register themselves upon creation
		 */
		(new LaunchHandler(launch)).register();

		/* Create a barrier for 2 handlers, 
		 * Triggers launch event when ready to proceed
		 */
		Barrier barrier = new Barrier(2, launch);
		
		/* The fire1 and fire2 events release fire1Handler and fire2Handler. */
		AperiodicEvent fire1 = new AperiodicEvent(); 	
		AperiodicEvent fire2 = new AperiodicEvent(); 
		
		/*
		 * Create Fire1 and Fire2 AEH
		 * Pass a reference to the shared barrier
		 * ManagedHandlers need to register themselves upon creation
		 */
		(new FireHandler(fire1, barrier, 0)).register();
		(new FireHandler(fire2, barrier, 1)).register();
		
		/*
		 * Create PEHs that generate event occurences.
		 */
		(new Button(fire1, 2000, 0)).register();	//2s
		(new Button(fire2, 9000, 9000)).register();	//9s + 9s offset
	}
}
