import javax.realtime.AperiodicParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;

public class LaunchHandler extends AperiodicEventHandler {

	public LaunchHandler(AperiodicEvent launch) {
		
		super(//priority
			  new PriorityParameters(PriorityScheduler.instance().getMaxPriority()),
			  //release
			  new AperiodicParameters(),
			  //storage
			  new StorageConfigurationParameters(32768, 4096, 4096),
			  //event
		      launch,
			  //name
			  "LaunchHandler"
		      );
	}

	public void handleEvent() {
			System.out.println(" LAUNCHING MISSILE ");
	}

}
